IMPLEMENTATION MODULE M2DM;
(*
 * 19.2.90/bp
 *	Mit -g kompilieren, dann engl. Version!
 *
 * 26.8.89/ms
 *	Ren's Vorschlag fr die LowMemory Behandlung bernommen. Es war
 *	zudem ein Fehler in der AllcoateMemory Prozedur, der eine negative
 *	Blockgrsse von Heap erwartet htte.
 * 30.5.89/ms
 *	Die bestehende Implementation von M2DM wird so erweitert, dass
 *	auch eine dynamische Verwaltung des Bezeichnerbereiches mglich
 *	wird.
 *)
(*$ LargeVars:=FALSE LongAlign:=TRUE StackChk:=FALSE
    StackParms:=FALSE Volatile:=FALSE
 *)
(*$ DEFINE English:=FALSE *)

FROM SYSTEM	IMPORT	ADDRESS,ADR,CAST,ASSEMBLE;
FROM Arts	IMPORT	Requester,Exit,BreakPoint;
FROM Heap	IMPORT	AllocMem,Deallocate,Largest;

CONST
 maxChunk=8000;
 saveMem=20000;

 header= "Amiga Modula-2 Compiler";

(*$ IF English *)
 body="Insufficient Memory";
 abort=" Abort ";
 retry=" Retry ";
(*$ ELSE *)
 body="Nicht gengend Speicher";
 abort=" abbrechen ";
 retry=" weiter ";
(*$ ENDIF *)

TYPE
 StorageNodePtr=POINTER TO StorageNode;
 StorageNode=RECORD
  next: StorageNodePtr;
  size,
  free: INTEGER;
  data: LONGINT;
 END;

VAR
 heap,
 hunkHeap,
 lev0Heap: StorageNodePtr;


(*$ EntryExitCode:=FALSE *)
PROCEDURE Diff(i{6},j{7}: Ident): INTEGER;
BEGIN
 ASSEMBLE(
 	MOVE.L	D6,A0
 	MOVE.L  D7,A1
 	(* 20.12.90/bp *)
	MOVE.W	(A0),D1 (* Lnge mit vergleichen!! *)
	ADDQ.W	#1,D1
 Loop:	CMPM.B	(A1)+,(A0)+
 	DBNE	D1,Loop (* EQ: gleich ret 0 HI: 1.grer ret + sonst - *)
	BHI.S	Gr (* i ist grer! *)
	BLO.S	Lo
 	MOVEQ	#0,D0
	RTS
Gr:	MOVEQ	#1,D0
	RTS
Lo:	MOVEQ	#-1,D0
	RTS
  END)
END Diff;

PROCEDURE AllocateMemory(VAR a: ADDRESS; min,max: LONGINT): INTEGER;
VAR
 size: LONGINT;
BEGIN
 REPEAT
  LOOP
  (*
   * Only if we can leave at least 20K continuos memory we will
   * allocate the memory. Otherwise we will tell the user, that
   * we can't allocate the memory and offer a possibility to retry.
   *)
   size:=Largest(FALSE)-saveMem;
   IF size>=min THEN
    EXIT
   ELSIF ~Requester(ADR(header),ADR(body),ADR(retry),ADR(abort)) THEN
    Exit(10);
   END
  END;
  IF size>max THEN
   size:=max
  END;
  AllocMem(a,size,FALSE)
 UNTIL a#NIL;
 RETURN size;
END AllocateMemory;

PROCEDURE ALLOCATE2(VAR a: ADDRESS; n: INTEGER; VAR hp:StorageNodePtr);
VAR
 temp: StorageNodePtr;
 blockSize: INTEGER;
 maxSize,oldn: INTEGER;
BEGIN
 a:=NIL;
 IF ODD(n) THEN INC(n) END;
 oldn:=n;
 IF (hp=NIL) OR (hp^.free<n) THEN
  IF n<=maxChunk THEN
   maxSize:=maxChunk
  ELSE
   maxSize:=n;
  END;
  blockSize:=n+SIZE(StorageNode);
  INC(maxSize,SIZE(StorageNode));
  blockSize:=AllocateMemory(temp,blockSize,maxSize);
  WITH temp^ DO
   next:=hp;
   data:=CAST(LONGINT,temp)+SIZE(StorageNode);
   free:=blockSize-SIZE(StorageNode);
   size:=free;
  END;
  hp:=temp;
 END;
 WITH hp^ DO
  DEC(free,n);
  a:=CAST(ADDRESS,data+free);
  ASSEMBLE(
	MOVEA.L	a(A5),A0
	MOVEA.L	(A0),A0 (* weil VARpar *)
	MOVE.W	oldn(A5),D0
	ASR.W	#1,D0 (* /2 = Worte *)
	BLE.S	raus
	SUBQ.W	#1,D0
	MOVEQ	#0,D1
   lp:	MOVE.W	D1,(A0)+
	DBRA	D0,lp
   raus:
  END);
 END;
END ALLOCATE2;

PROCEDURE ALLOCATE(VAR a: ADDRESS; n: INTEGER);
BEGIN
  ALLOCATE2(a,n,heap);
END ALLOCATE;

PROCEDURE AllocHunkLev(VAR a:ADDRESS; n:INTEGER);
BEGIN
  ALLOCATE2(a,n,hunkHeap);
END AllocHunkLev;

PROCEDURE AllocLev0(VAR a:ADDRESS; n:INTEGER);
BEGIN
  ALLOCATE2(a,n,lev0Heap);
END AllocLev0;


PROCEDURE Reset(VAR c: StorageNodePtr; adr: LONGINT);
VAR
 temp:StorageNodePtr;
BEGIN
 WHILE (c#NIL) & ( (adr < c^.data+c^.free) OR (c^.data+c^.size <= adr) ) DO
  temp:=c;
  c:=c^.next;
  Deallocate(temp);
 END;
 IF c#NIL THEN
  c^.free:=adr-c^.data; (* Hier killt der Compiler d2 !! *)
 END;
END Reset;

PROCEDURE ResetHeap(adr:ADDRESS);
BEGIN
 Reset(heap, CAST(LONGINT,adr));
END ResetHeap;

PROCEDURE ResetHunkHeap;
BEGIN
 Reset(hunkHeap, 0);
END ResetHunkHeap;

PROCEDURE ResetLev0Heap;
BEGIN
 Reset(lev0Heap, 0);
END ResetLev0Heap;

PROCEDURE ResetL0Heap(adr:ADDRESS);
BEGIN
 Reset(lev0Heap, CAST(LONGINT,adr));
END ResetL0Heap;


BEGIN
(*
 heap:=NIL;
 hunkHeap:=NIL;
 lev0Heap:=NIL;
*)
END M2DM.
