MODULE M2ConvError;
(*$ LargeVars:=FALSE StackChk:=FALSE Volatile:=FALSE StackParms:=FALSE *)
(*
 * 24.6.91/bp konvertiert aus text und fehlerdatei eine neue in folgender
 * Form:
 * line col "complete message"\n
 * 12.11.90/bp
 * Neue Option +-lNummer : nur die Nummer ausgeben
 * 4.9.90/bp
 * Aktuelle Version ist deutsch UND englisch!
 *
 * 27.05.89 / ms
 *
 * Aktuelle Version ist in DEUTSCH
 *
 * 20.8.91/bp Da immer voler Pfad gegeben wird, entfaellt M2File-Suche!
 * Ausserdem gibt es nun m2op!
 *)
(*$ DEFINE English:=FALSE *)
FROM SYSTEM	IMPORT	ADDRESS,BITSET,ADR,CAST,SETREG;
FROM Arguments	IMPORT	GetArg;
FROM Arts	IMPORT	programName, Exit,BreakPoint;
FROM ASCII	IMPORT	nul,ht,eol,eof;
FROM SeqIO	IMPORT	SeqKey,OpenSeqIn,CloseSeq,SeqGetB,SeqInCount,
			SeqInLen,SeqOk,SeqInPos;
FROM Terminal	IMPORT	waitCloseGadget,Read,Write,WriteLn,WriteString,
			Format,FormatS,ReadLn,FormatNr;
FROM String	IMPORT	Occurs,LastPos,Length;
FROM M2Amiga	IMPORT	GetErrMsgs, FreeErrMsgs, ErrorPtr;

CONST
 title1="m2ConvError";
 title2=
(*$ IF English *) "Amiga Modula-2 Error Converter";
(*$ ELSE *)	  "Amiga Modula-2 FehlerKonverter";
(*$ ENDIF *)
 ver="4.4";
 date=COMPILEDATE;
 verDollar="$VER: m2ConvError "+ver+" "+date;

 errTag=CHAR(0C1H);
 strTag=CHAR(0C2H);
(*
 defDir="txt/";
 defExt=".def";
 modDir=defDir;
 modExt=".mod";
*)
TYPE
 ErrorType=(number,string);
 ErrorPart=RECORD
  type: ErrorType;
  errNo: INTEGER;
  str: ARRAY [0..63] OF CHAR
 END;

VAR
 poses:ARRAY[0..200] OF LONGINT;
 err,src: SeqKey;
 errLst: ErrorPtr;
 fName:ARRAY[0..127] OF CHAR;
 ch: CHAR; (* global lookahead character *)
 cp,lastPos: LONGINT;
 llen,
 actPos,
 fNameLen: INTEGER;
 interactive,notX: BOOLEAN;
 lineNr: CARDINAL;
 line,out: ARRAY [0..511] OF CHAR;


PROCEDURE FetchErrMsg(errLst: ErrorPtr; error: INTEGER);
VAR
 stk: RECORD no: INTEGER; str: ADDRESS END;
 errPtr: ErrorPtr;
BEGIN
 stk.no:=error;
 errPtr:=errLst;
 WHILE (errLst#NIL) & (errLst^.no#error) DO
  errLst:=errLst^.next
 END;
 (* 21.2.89/ms
  * Falls der Fehler nicht gefunden wird, kann es sich noch
  * um einen 68xx Fehler handeln. Diese sind mit Nullen anstelle der x
  * in der Liste eingetragen.
  *)
 IF errLst=NIL THEN
  errLst:=errPtr;
  error:=error-(error MOD 100);
  WHILE (errLst#NIL) & (errLst^.no#error) DO
   errLst:=errLst^.next
  END
 END;
 IF errLst#NIL THEN
  WITH errLst^ DO
   stk.str:=ADR(msg);
  END;
  IF error<=15000 THEN
   Format(" %d: %s",ADR(stk))
  ELSE
   Format(" %s",ADR(stk.str))
  END
 ELSE
  Format("<%d>",ADR(error))
 END
END FetchErrMsg;

PROCEDURE ReadErrorPos(VAR errorPos: LONGINT): BOOLEAN;
VAR
 trick: RECORD
  CASE :INTEGER OF
  | 1: ch: ARRAY [0..3] OF CHAR
  | 2: li: LONGINT
  END
 END;
BEGIN
 IF ch=errTag THEN
  SeqGetB(err,ch);
  SeqGetB(err,ch);
  SeqGetB(err,ch);
  WITH trick DO
   SeqGetB(err,ch[0]);
   SeqGetB(err,ch[1]);
   SeqGetB(err,ch[2]);
   SeqGetB(err,ch[3]);
   errorPos:=li
  END;
  SeqGetB(err,ch);
  RETURN SeqOk(err);
 END;
 RETURN FALSE
END ReadErrorPos;

PROCEDURE ReadErrorPart(VAR errorPart: ErrorPart): BOOLEAN;
VAR
 i: INTEGER;
BEGIN
 WITH errorPart DO
  IF ch<CHAR(080H) THEN
   type:=number;
   errNo:=ORD(ch);
   SeqGetB(err,ch);
   errNo:=256*errNo+ORD(ch);
   SeqGetB(err,ch)
  ELSIF ch=strTag THEN
   type:=string;
(* 28.5.89/ms Einfgen eies Leerzeichens am Anfang des Strings *)
   str[0]:=' '; i:=1;
   REPEAT
    SeqGetB(err,ch);
    IF i<128 THEN str[i]:=ch END;
    INC(i)
   UNTIL ch=nul;
   IF ODD(i) THEN SeqGetB(err,ch) END;
   SeqGetB(err,ch)
  ELSE
   RETURN FALSE
  END
 END;
 RETURN SeqOk(err)
END ReadErrorPart;

PROCEDURE DisplayPos(errPos: LONGINT);
BEGIN
 poses[actPos]:=errPos;
 INC(actPos);
END DisplayPos;

PROCEDURE DisplayPart(part: ErrorPart);
BEGIN
 WITH part DO
  IF type=string THEN
   WriteString(str)
  ELSE
   FetchErrMsg(errLst,errNo);
  END
 END
END DisplayPart;

PROCEDURE ShowError(VAR name: ARRAY OF CHAR): BOOLEAN;
VAR
 i,len: INTEGER;
 plen,errPos: LONGINT;
 part: ErrorPart;
 result: BOOLEAN;
BEGIN
 result:=TRUE;
 lineNr:=0;
 len:=Length(name);
 cp:=0; lastPos:=0;
 IF OpenSeqIn(src,name,256) THEN
  name[len]:='E'; name[len+1]:=nul;
  IF OpenSeqIn(err,name,2048) THEN
   (*$ IF English *)
     WriteString("\n\n\n\n\n\n\n\n\n\nv No previous errors\n");
   (*$ ELSE *)
     WriteString("\n\n\n\n\n\n\n\n\n\nv Keine vorhergehenden Fehler\n");
   (*$ ENDIF *)
   actPos:=0;
   name[len]:=nul;
   FOR i:=0 TO 4 DO SeqGetB(err,ch) END; (* skip tag / read first char *)
   WHILE ReadErrorPos(errPos) DO
    DisplayPos(errPos);
    (*Write(ht); Write('|');*)
    WHILE ReadErrorPart(part) DO
     DisplayPart(part)
    END;
    WriteLn
   END;
   (*$ IF English *)
     WriteString("^ No more errors\n\n\n\n");
   (*$ ELSE *)
     WriteString("^ Keine weiteren Fehler\n\n\n\n");
   (*$ ENDIF *)
   CloseSeq(err);
   plen:=0;
   FOR i:=0 TO actPos-1 DO
     FormatNr("%ld ",poses[i]-plen);
     plen:=poses[i];
   END;
   WriteLn;
  ELSE
   Exit(22);
  END;
  CloseSeq(src);
  RETURN FALSE
 ELSE
  Exit(23);
  RETURN TRUE
 END
END ShowError;

VAR
 argErr,dejaVue,listMsgs: BOOLEAN;


BEGIN
 SETREG(11,ADR(verDollar));
 GetArg(1,fName,fNameLen);
 IF fNameLen=0 THEN Exit(20) END;

 errLst:=GetErrMsgs();
 IF errLst#NIL THEN
   (*
   ReadPathTable(pathFileName);
   *)
   argErr:=ShowError(fName) OR argErr;
 ELSE
   Exit(22)
 END;
CLOSE
  IF errLst#NIL THEN FreeErrMsgs; errLst:=NIL END;
END M2ConvError.
