IMPLEMENTATION MODULE M2Bll;
(*$ LargeVars:=FALSE StackParms:=FALSE StackChk:=FALSE Volatile:=FALSE *)

(* made from m2soc /bp 16.12.89 *)
(* 20.1.91/bp angepat fr neue VarModes und lange Ids *)
(* 1.2.91/bp REFFILE kann 10..19 sein! *)
(* 05.09.92/bp externe Vars in Refs haben Name statt adr *)

FROM SYSTEM	IMPORT	ADDRESS,BYTE,ADR,CAST,BITSET,ASSEMBLE;
FROM Arts	IMPORT	Assert, BreakPoint;
FROM FileSystem	IMPORT	File,Response,Close,Lookup,ReadChar,ReadBytes,
			ReadByteBlock, WriteChar, WriteBytes, GetPos, SetPos;
FROM String	IMPORT	Concat,Length,Copy,Compare, FirstPos, LastPos,
			Occurs, Insert, Delete;
FROM Terminal	IMPORT	WriteLn,WriteString,FormatS,Format,Flush;
FROM M2File	IMPORT	FileType, GetInputFile, GetFileName, GeneratingNew;
FROM M2Amiga	IMPORT	MakeIcon;
FROM ExecD	IMPORT	NodeType;
FROM Cio	IMPORT	fprintf, sprintf; (* BPs special power! *)
FROM MLinkBase	IMPORT	ALLOCATE,Diff,NameRecPtr;
IMPORT DosD,DosL;

CONST
 eol=12C;
 REFFILE=10; (* ..19 *)
 CTL=0; anchor=0; ModTag=1; ProcTag=2; RefTag=3; linkage=4;
 STR=1; enum=0; range=1; pointer=2; set=3; procTyp=4; funcTyp=5;
 array=6; dynarr=7; record=10; opaque=11; bpointer=12;
 CMP=2; parref=0; par=1; field=2;
 OBJ=3; varref=0; var=1; const=2; string=3; type=4; proc=5; func=6;
 module=7; svc=10; svcfunc=11;

 extVar=4; smallextvar=5;

VAR
 idBuf,
 inName,
 outName: ARRAY [0..127] OF CHAR;
 ch1,ch2,blk:CHAR;
 adr,d,fileType:LONGINT;
 dr:RECORD a,b:LONGINT END; (* LONGREAL brauchen wir nicht! *)
 ref: File;

 pc,block,len,pno,
 level, strRef, modRef, resRef, parRef, modtyp,varmode: INTEGER;
 keys:ARRAY[0..2] OF INTEGER;
 registers:BITSET;
 exported:BOOLEAN;
 again: BOOLEAN;
 lastB: BYTE;
 verfound,revfound,sizefound:BOOLEAN;

(*$ LongAlign:=TRUE *)

(* Macht gleichzeitig String und NameRec *)
(*$ CopyDyn:=FALSE *)
PROCEDURE Enter(name: ARRAY OF CHAR): NameRecPtr;
VAR
 i,l: INTEGER;
 ll:LONGINT;
 id: NameRecPtr;
BEGIN
 l:=Length(name);
 ll:=l+4; (* +3 fr Rundung, +1 fr sichere 0 am Ende! *)
 ALLOCATE(id,ll+4);
 id^.lws:=(l+3) DIV 4;
 FOR i:=0 TO l-1 DO
  id^.name[i]:=name[i]
 END;
 (* ALLOCATE fllt mit 0, also Rest ok!! *)
 RETURN id;
END Enter;


(*$ RangeChk:=FALSE OverflowChk:=FALSE *)
PROCEDURE InB(VAR b:BYTE);
BEGIN
 IF again THEN
  again:=FALSE; b:=lastB;
 ELSE
  ReadChar(ref,CAST(CHAR,b)); lastB:=b;
 END;
END InB;

PROCEDURE InNumber(VAR x:ARRAY OF BYTE);
VAR
 i,k,l:INTEGER;
 c:CARDINAL;
 ch:CHAR;
 fill:BYTE;
BEGIN
 InB(ch); c:=ORD(ch);
 l:=HIGH(x);
 fill:=0;
 IF c<64 THEN
  IF c>31 THEN INC(c,192); fill:=0FFH END;
  x[l]:=CAST(BYTE,CHAR(c)); DEC(l);
 ELSIF c<128 THEN
  DEC(c,64); IF c>31 THEN INC(c,192); fill:=0FFH END;
  x[l-1]:=CAST(BYTE,CHAR(c)); InB(x[l]);
  DEC(l,2);
 ELSIF c<192 THEN
  DEC(c,128); IF c>31 THEN INC(c,192); fill:=0FFH END;
  x[l-2]:=CAST(BYTE,CHAR(c)); InB(x[l-1]); InB(x[l]);
  DEC(l,3);
 ELSE
  k:=l-INTEGER(c MOD 64);
  FOR i:=k+1 TO l DO InB(x[i]); END;
  IF CAST(CHAR,x[k+1])>=200C THEN fill:=0FFH END;
  l:=k;
 END;
 FOR i:=0 TO l DO x[i]:=fill; END;
END InNumber;

PROCEDURE InExported;
VAR i:INTEGER;
BEGIN
  InNumber(i);
  exported:=i#0;
END InExported;

PROCEDURE InId;
VAR
 ch: CHAR;
 i,len: INTEGER;
BEGIN
 InNumber(i);
 len:=i-1;
 FOR i:=0 TO len-1 DO
  InB(ch); IF i<127 THEN idBuf[i]:=ch END;
 END;
 IF len<=127 THEN idBuf[len]:=0C END;
END InId;
(*$ POP RangeChk POP OverflowChk *)

(*$ CopyDyn:=FALSE *)
PROCEDURE ReadRefFile(name: ARRAY OF CHAR; verbose:BOOLEAN):LoadError;
VAR
 ok: BOOLEAN;
 i: INTEGER;
 procAdr: LONGINT;
 tp, TempPars, NewPar: ParaPtr;

BEGIN
 ok:=FALSE; procAdr:=0;
 TempPars:=NIL;
 Lookup(ref, name, 2048, FALSE);
 IF verbose THEN
   WriteString(" - "); WriteString(name); Flush;
 END;
 IF ref.res=done THEN
  again:=FALSE;
  ReadBytes(ref,ADR(fileType),SIZE(fileType),d);
  ok:=(d=SIZE(fileType)) & (fileType>=REFFILE) & (fileType<=REFFILE+9);
  LOOP
   InB(blk); block:=ORD(blk);
   IF ref.eof THEN
    EXIT
   ELSIF ~ok OR (ref.res#done) THEN
    ok:=FALSE;
    EXIT
   END;
   CASE block DIV 16 OF
   | OBJ:
    DEC(block,16*OBJ);
    CASE block OF
    | varref: InNumber(strRef);InNumber(level);InNumber(adr);InNumber(varmode);
    		IF (varmode>=extVar)&(varmode<=smallextvar) THEN InId END;
    | var:    InNumber(strRef);InNumber(level);InNumber(adr);InNumber(varmode);
    		IF (varmode>=extVar)&(varmode<=smallextvar) THEN InId END;
    | const:  InNumber(strRef);InNumber(modRef);InNumber(dr);
    | string: InNumber(strRef); InId;
    | type:   InNumber(strRef);InNumber(modRef);
    | proc,func:
     IF block=func THEN InNumber(resRef) END;
     InNumber(pno);InNumber(level);
     IF level<0 THEN
       InId;
       (* level<0 bleibt stehen fuer unten *)
     ELSE
       InNumber(adr);
     END;
     InNumber(d);InNumber(registers);
    | module: InNumber(d); (* modNo *)
    | svc,svcfunc:
     IF block=svcfunc THEN InNumber(resRef) END;
     InNumber(pno)
    END;
    InId;InExported;
    IF ((block=proc) OR (block=func)) THEN
     tp:=TempPars;
     TempPars:=NIL;
     IF (exported) & (level=0) THEN
      DEC(procAdr,6);
      WITH procArr[procs] DO
       id:=Enter(idBuf);
       pars:=tp;
       adr:=procAdr;
      END;
      INC(procs);
     END;
    (*
    ELSIF (block=svc) OR (block=svcfunc) THEN
     WITH procArr[procs] DO
      id:=Enter(idBuf);
      adr:=pno;
     END;
     INC(procs)
     ignore!
     *)
    ELSIF (block=const) & (strRef=16) & (modRef=0) THEN (* univ. Integer *)
     IF Compare(VerName,idBuf)=0 THEN
       verfound:=TRUE;
       version:=dr.b;
     ELSIF Compare(RevName,idBuf)=0 THEN
       revfound:=TRUE;
       revision:=dr.b
     ELSIF Compare(SizeName,idBuf)=0 THEN
       sizefound:=TRUE;
       libSize:=dr.b
     END;
    END
   | CMP:
    DEC(block,16*CMP);
    ok:=ok & (block<=field);
    InNumber(strRef);InNumber(parRef);InId;
    IF (block=par) OR (block=parref) THEN
      ALLOCATE(NewPar,SIZE(NewPar^));
      WITH NewPar^ DO
        next:=NIL;
        id:=Enter(idBuf);
        register:=parRef;
      END;
      IF TempPars=NIL THEN
        TempPars:=NewPar
      ELSE
        tp:=TempPars;
        WHILE tp^.next#NIL DO tp:=tp^.next END;
        tp^.next:=NewPar;
      END;
    END;
   | STR:
    DEC(block,16*STR);
    ok:=ok & (block<=bpointer);
    InNumber(d);
    CASE block OF
    | enum:
     InNumber(d)
    | range:
     InNumber(d);InNumber(d);InNumber(d);InNumber(d);
    | set:
     InNumber(d)
    | procTyp,funcTyp:
     TempPars:=NIL; (* liefert auch Pars!!! *)
     IF ORD(block)=funcTyp THEN InNumber(d) END;
    | array:
     InNumber(d);InNumber(d);
    | dynarr:
     InNumber(d);
    ELSE
    END;
   | CTL:
    DEC(block,16*CTL);
    IF block=linkage THEN
     InNumber(d);InNumber(d);
    ELSIF block=ModTag THEN (*main module*)
     InNumber(d)
    ELSIF block=anchor THEN
      ReadByteBlock(ref, keys);
      InId;
      InNumber(modtyp);
      IF modtyp=2 THEN (* library module *)
       InId; (* get module name *)
      END;
    ELSIF block=RefTag THEN
     InNumber(d);InNumber(d);
    ELSIF block=ProcTag THEN
      InNumber(d);
    ELSE
     ok:=FALSE;
    END
   ELSE (*line block*)
    again:=TRUE;
    InNumber(d); InNumber(d);
   END;
  END; (* LOOP *)
  Close(ref);
 ELSE
  RETURN refFindErr
 END;
 IF verbose THEN WriteLn END;
 IF ok THEN
   RETURN loadOk
 ELSE
   RETURN refErr
 END;
END ReadRefFile;

PROCEDURE PutFd(VAR Naked:ARRAY OF CHAR; bias:INTEGER; verbose,makeIcon:BOOLEAN):LoadError;
CONST Regs ='??D0D1D2D3D4D5D6D7A0A1A2A3A4A5A6A7';
VAR f:DosD.FileHandlePtr;
    sp:ADDRESS;
    i: INTEGER;
    para: ParaPtr;
BEGIN
  Copy(outName,Naked);
  Concat(outName,'_lib.fd');
  f:=DosL.Open(ADR(outName),DosD.newFile);
  IF verbose THEN
    FormatS(' + %s',outName); Flush;
  END;
  IF f=NIL THEN
    RETURN createFDerr;
  END;
  sp:=ADR(Naked);
  fprintf(f,'##base _%sBase\n',ADR(sp));
  fprintf(f,'##bias %d\n##public\n',ADR(bias));
  FOR i:=(bias-6)/6 TO procs-1 DO
    para:=procArr[i].pars;
    sp:=ADR(procArr[i].id^.name);
    fprintf(f,'%s(',ADR(sp));
    WHILE para#NIL DO
      fprintf(f,para^.id^.name,NIL);
      IF para^.next#NIL THEN fprintf(f,',',NIL) END;
      para:=para^.next;
    END;
    fprintf(f,')',NIL);
    para:=procArr[i].pars;
    IF para#NIL THEN
      fprintf(f,'(',NIL);
      WHILE para#NIL DO
        sp:=ADR(Regs)+2*para^.register;
        fprintf(f,'%2.2s',ADR(sp));
        IF para^.next#NIL THEN fprintf(f,',',NIL) END;
        para:=para^.next;
      END;
      fprintf(f,')\n',NIL);
    ELSE
      fprintf(f,'\n',NIL);
    END;
  END; (* for *)
  fprintf(f,'##end\n',NIL);
  DosL.Close(f);
  IF verbose THEN
    WriteLn;
  END;
  IF makeIcon THEN MakeIcon(outName,'txt') END;
  RETURN loadOk;
END PutFd;

PROCEDURE GetLn(VAR f:File; VAR s:ARRAY OF CHAR);
VAR ch:CHAR;
    i:INTEGER;
BEGIN
  i:=0;
  REPEAT
    ReadChar(f,ch);
    IF ~f.eof THEN
      s[i]:=ch;
      INC(i);
    END;
  UNTIL (ch=eol) OR (i>=HIGH(s)) OR (f.eof) OR (f.res#done);
  s[i]:=0C;
END GetLn;

PROCEDURE PutLn(VAR f:File; VAR s:ARRAY OF CHAR);
VAR actual:LONGINT;
BEGIN
  WriteBytes(f,ADR(s),Length(s),actual);
END PutLn;

(*$ CopyDyn:=FALSE *)
PROCEDURE Puts(VAR f:File; s:ARRAY OF CHAR);
VAR actual:LONGINT;
BEGIN
  WriteBytes(f,ADR(s),Length(s),actual);
  WriteChar(f,eol);
END Puts;

PROCEDURE PutDef(VAR MName, Naked, LibName: ARRAY OF CHAR; type:NodeType;
		 verbose, makeIcon:BOOLEAN):LoadError;
VAR
  pos1,pos2,ResProcs,i:INTEGER;
  err: LoadError;
  fi,fo: File;
  adr: RECORD in,out:ADDRESS END;
  paras: RECORD str:ADDRESS; ver:INTEGER END;
  LibFull: ARRAY[0..79] OF CHAR;

  PROCEDURE CopyProc(write:BOOLEAN);
  VAR pos:LONGINT; ch:CHAR; kl:INTEGER;
  BEGIN
    GetPos(fi,pos);
    DEC(pos,Length(idBuf));
    SetPos(fi,pos);
    kl:=0;
    REPEAT
      ReadChar(fi,ch);
      IF write THEN WriteChar(fo,ch) END;
      IF ch='(' THEN INC(kl)
      ELSIF ch=')' THEN DEC(kl)
      END;
    UNTIL ((ch=';') AND (kl=0)) OR fi.eof;
    GetLn(fi,idBuf); (* Zeilenrest *)
    IF write THEN PutLn(fo,idBuf) END;
  END CopyProc;

BEGIN
 (* Dies ist eine sehr, sehr kranke Von-Neumann-Maschine!! *)
  err:=loadOk;
  adr.in:=ADR(inName); adr.out:=ADR(outName);
  IF type=library THEN
    ResProcs:=4
  ELSIF type=device THEN
    ResProcs:=6
  ELSE
    ResProcs:=0
  END;
  GetFileName(outName,defFile,Naked,TRUE);
  GetInputFile(inName,defFile,MName);
  IF verbose THEN
    Format(' - %s',ADR(adr.in)); Flush;
  END;
  Lookup(fi,inName,1000,FALSE);
  IF fi.res#done THEN
    RETURN noDef
  END;
  IF verbose THEN
    Format('\n + %s',ADR(adr.out)); Flush;
  END;
  GeneratingNew(Naked,defFile);
  Lookup(fo,outName,1000,TRUE);
  IF fo.res=done THEN
    (* lesen, schreiben bis Ende *)
    (* Kopf ndern, erste Prozeduren raus, alle anderen CODE -xx *)

    (* Kopf *)
    IF type#library THEN
      Puts(fo,"(*$ Implementation:=FALSE *)");
    END;
    LOOP
      GetLn(fi,idBuf);
      IF (fi.eof) OR (fi.res#done) THEN EXIT END;
      IF Occurs(idBuf,0,'MODULE',TRUE)>=0 THEN
        pos1:=Occurs(idBuf,0,MName,TRUE);
        IF pos1>0 THEN
          Delete(idBuf,pos1,Length(MName));
          IF type=library THEN
            paras.str:=ADR(LibName);
            paras.ver:=version;
            sprintf(LibFull,' {"%s", %d}',ADR(paras));
            Insert(idBuf,pos1,LibFull);
          END;
          Insert(idBuf,pos1,Naked);
          PutLn(fo,idBuf);
          EXIT;
        END;
      END;
      PutLn(fo,idBuf);
    END; (* loop *)

    (* CONST suchen, ..Name=LibName *)
    LOOP
      IF (fi.res=done) & (~fi.eof) THEN
        GetLn(fi,idBuf);
        IF Occurs(idBuf,0,'CONST',TRUE)>=0 THEN
	  PutLn(fo,idBuf);
	  LibFull:='  ';
	  Concat(LibFull,Naked);
	  IF (LibFull[2]>='A')&(LibFull[2]<='Z') THEN INC(LibFull[2],20H) END;
	  Concat(LibFull,'Name = "');
	  Concat(LibFull,LibName);
	  Concat(LibFull,'";');
	  Puts(fo,LibFull);
	  EXIT;
	END; (* if *)
	PutLn(fo,idBuf);
      END; (* if done *)
    END; (* loop *)

    (* festgelegte Prozeduren suchen *)
    i:=0;
    WHILE ResProcs>0 DO
      LOOP
        IF (fi.res=done) & (~fi.eof) THEN
          GetLn(fi,idBuf);
          IF (Occurs(idBuf,0,'PROCEDURE',TRUE)>=0) AND
		(Occurs(idBuf,0,procArr[i].id^.name,TRUE)>=0) THEN
	    CopyProc(FALSE);
	    INC(i);
	    DEC(ResProcs);
	    EXIT;
          END;
          PutLn(fo,idBuf);
        END; (* if done *)
      END; (* loop *)
    END; (* while resprocs>0 *)
  (* Ich glaube, es wre einfacher, das reffile zu nehmen!! *)

    (* exportierte Procs: *)
    WHILE i<procs DO
      LOOP
        IF (fi.res=done) & (~fi.eof) THEN
          GetLn(fi,idBuf);
          IF (Occurs(idBuf,0,'PROCEDURE',TRUE)>=0) AND
	     (Occurs(idBuf,0,procArr[i].id^.name,TRUE)>=0) THEN
	      (* wo ist das Ende der Prozedur????? *)
	    CopyProc(TRUE);
	    sprintf(LibFull,'CODE %ld;\n',ADR(procArr[i].adr));
	    PutLn(fo,LibFull);
	    INC(i);
	    EXIT;
          END;
          PutLn(fo,idBuf);
        END; (* if done *)
      END; (* loop *)
    END; (* while i<procs *)
    (* END mod *)
    LOOP
      IF (fi.res=done) & (~fi.eof) THEN
	GetLn(fi,idBuf);
	IF (Occurs(idBuf,0,'END',TRUE)>=0) &
	   (Occurs(idBuf,0,MName,TRUE)>=0) &
	   (Occurs(idBuf,0,'.',TRUE)>=0) THEN
	  pos1:=Occurs(idBuf,0,MName,TRUE);
	  Delete(idBuf,pos1,Length(MName));
	  Insert(idBuf,pos1,Naked);
	END;
	PutLn(fo,idBuf);
      ELSE
        EXIT
      END;
    END; (* loop *)
    Close(fo);
    IF fo.res#done THEN
      err:=createDefErr
    ELSE
      IF makeIcon THEN MakeIcon(outName,'txt') END;
    END;
  ELSE
    err:=createDefErr;
  END;
  Close(fi);
  IF verbose THEN WriteLn END;
  RETURN err;
END PutDef;

PROCEDURE CheckAll(VAR MName,Naked,LibName:ARRAY OF CHAR; type:NodeType;
		   verbose, makeFD, makeDef, makeIcon:BOOLEAN):LoadError;
VAR
  fileName:ARRAY[0..79] OF CHAR;
  i:INTEGER;
  err: LoadError;
  bias:INTEGER;
BEGIN
  procs:=0; verfound:=FALSE; revfound:=FALSE; sizefound:=FALSE;
  GetInputFile(fileName, refFile, MName);
  err:=ReadRefFile(fileName,verbose);
  IF err#loadOk THEN RETURN err END;
  IF type=library THEN bias:=30
  ELSIF type=device THEN bias:=42
  ELSE bias:=6
  END;
  IF procs<(bias-6)/6 THEN RETURN notEnoughProcs END;
  IF ~(revfound&verfound&sizefound) THEN RETURN verrevNotDef END;
  IF makeFD THEN
    err:=PutFd(Naked,bias,verbose,makeIcon);
    IF err#loadOk THEN RETURN err END;
  END;
  IF makeDef THEN
    err:=PutDef(MName, Naked, LibName, type, verbose, makeIcon);
    IF err#loadOk THEN RETURN err END;
  END;
  RETURN loadOk;
END CheckAll;


BEGIN
END M2Bll.
