IMPLEMENTATION MODULE M2Base; (* jr/1jan88 *)
(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)

FROM SYSTEM	IMPORT	ADDRESS, ADR, CAST;
FROM Arts	IMPORT	Assert;
FROM ExecD	IMPORT	MemReqs,MemReqSet;
FROM ExecL	IMPORT	AllocMem, FreeMem;
FROM String	IMPORT	Compare, Copy;
(*
 $ F- all functions do have their RETURN
 $ R- I'm not a bad boy..
 $ V- where can here be an overflow??
*)

CONST
  noSpace=
    (*  "Zuwenig Speicherplatz"; *)
    "Insufficient Memory";
  illSize="BlockSize<0|>4096-4";
  myReqs=MemReqSet{memClear,public};


(* ------------------- simple memory management ------------------ *)

CONST
  blkSize=8096-4;
TYPE
  MemInfoPtr=POINTER TO MemInfo;
  MemInfo=RECORD
    next: MemInfoPtr;
    buf: ARRAY [0..blkSize-1] OF CHAR; (* must be the first field *)
  END;

VAR
  mem: RECORD
    list: MemInfoPtr;
    ptr: ADDRESS;
    avail: INTEGER
  END;

PROCEDURE GetMem(VAR a: ADDRESS; s: INTEGER);
VAR m: MemInfoPtr;
BEGIN
  IF ODD(s) THEN INC(s) END;
  IF s>mem.avail THEN (* get new block *)
    Assert((s>=0)&(s<=blkSize),ADR(illSize));
    m:=AllocMem(SIZE(m^),myReqs);
    Assert(m#NIL, ADR(noSpace));
    m^.next:=mem.list;
    mem.list:=m;
    mem.ptr:=ADR(m^.buf);
    mem.avail:=blkSize
  END;
  a:=mem.ptr; INC(mem.ptr, s);
  DEC(mem.avail, s)
END GetMem;

PROCEDURE ForgetMem;
VAR m,succ: MemInfoPtr;
BEGIN
  m:=mem.list; mem.list:=NIL; mem.avail:=0;
  WHILE m#NIL DO
    succ:=m^.next;
    FreeMem(m,SIZE(m^));
    m:=succ;
  END;
END ForgetMem;

(* ---------------- utility procedures ---------------- *)

PROCEDURE equalKey(VAR k1, k2: MKey): BOOLEAN;
(* 'k1' is the old key; 'k2' is the new key to be compared *)
VAR i: INTEGER;
BEGIN
  IF (k1[0]=k2[0]) & (k1[1]=k2[1]) & (k1[2]=k2[2]) THEN
    mError.type:=noError; RETURN TRUE
  ELSE
    i:=0; WHILE k1[i]=k2[i] DO INC(i) END;
    mError.old:=k2[i]<k1[i]; mError.type:=keyMismatch; RETURN FALSE
  END
END equalKey;

PROCEDURE equalName(VAR a, b: MName): BOOLEAN;
(* 'a' is the old name; 'b' is the new name to be compared *)
VAR i: INTEGER;
BEGIN
  WITH mError DO
    i:=0; name1:=a;
    IF Compare(a,b)#0 THEN
      type:=nameConflict;
      name2:=b;
      RETURN FALSE
    ELSE
      type:=noError;
      RETURN TRUE
    END
  END
END equalName;

BEGIN
  (* mem.list:=NIL *)
CLOSE
  ForgetMem;
END M2Base.mod
