(*---------------------------------------------------------------------------
    :Program.     FileIO.mod
    :Contents.	  komplette Files lesen und schreiben
    :Author.      Bernd Preusing
    :Address.	  Gerhardstr. 16  D-2200 Elmshorn
    :Phone.	  04121/22486
    :Copyright.	  Public Domain
    :Language.	  Modula-2
    :Translator.  M2Amiga V3.27d
    :History.	  1.0 14-Sep-89 Bernd Preusing
    :History.	  1.1 23-Sep-89 Bernd Preusing: neue PROCEDURE FreeFile
    :History.		und Fehlermeldung in PutFile korrigiert.
    :History.     1.2 15-Aug-92 BP nuntzt m2amiga.library
    :Bugs.	  none
    :Remark.      Dieses Modul war berfllig!
---------------------------------------------------------------------------*)
IMPLEMENTATION MODULE FileIO;
(*$ LargeVars:=FALSE StackParms:=FALSE StackChk:=FALSE Volatile:=FALSE *)
(* from .def:
TYPE
  FileIOResult= (noError, notFound, readError, writeError, saveError,
  		 noMem);
*)

FROM SYSTEM	IMPORT	ADR, ADDRESS, CAST;
FROM Arts	IMPORT	Assert;
FROM DosD	IMPORT	oldFile, newFile, end, beginning, FileHandlePtr,
			FileLockPtr,FileInfoBlock, FileInfoBlockPtr, sharedLock;
FROM DosL	IMPORT	Close, DeleteFile, Open, Read, Rename, Seek, Write,
			Lock, UnLock, Examine;
FROM Heap	IMPORT	Allocate, Deallocate;
FROM String	IMPORT	Copy, Concat;
FROM M2Amiga	IMPORT	Exists, ExistsResult;

TYPE
 CharPtr = POINTER TO CHAR;


VAR
    NewName: ARRAY [0..79] OF CHAR; (* not too much stack! *)

PROCEDURE FileExists(VAR Name: ARRAY OF CHAR):BOOLEAN;
BEGIN
  RETURN Exists(Name)=fileExists;
END FileExists;

PROCEDURE GetFile(VAR Name:ARRAY OF CHAR; VAR Addr:ADDRESS;
		  VAR Len:LONGINT; Add:LONGINT):FileIOResult;
VAR f: FileHandlePtr; actual:LONGINT; Buffer:CharPtr;
BEGIN
  f:=Open(ADR(Name),oldFile);
  IF f # NIL THEN
    actual:=Seek(f,0,end);
    Len:=Seek(f,0,beginning);
    IF Len<0 THEN
      Close(f);
      RETURN seekError
    END;
    Allocate(Buffer,Len+Add+1);
    IF Buffer#NIL THEN
      Addr:=Buffer;
      actual:=Read(f,Buffer,Len);
      IF (actual=Len) THEN
	INC(Buffer,Len); Buffer^:=0C;
	Close(f);
	RETURN noError;
      ELSE
        Close(f);
        Deallocate(Buffer);
	RETURN readError
      END;
    ELSE
      Close(f);
      RETURN noMem;
    END;
  ELSE
    RETURN notFound
  END
END GetFile;


PROCEDURE FreeFile(VAR Buffer:ADDRESS);
(* :Input.	Buffer: die mittels GetFile erhaltene Adresse
   :Semantic.   Gibt den Speicher des FilePuffers wieder frei
*)
BEGIN
  Deallocate(Buffer)
END FreeFile;


(* save file len, dealloc buffer on demand (only, if no error!!!),
   keep backup ('Name.bak') on demand *)
PROCEDURE PutFile(VAR Name:ARRAY OF CHAR; Buffer:ADDRESS;
		  Len:LONGINT; Backup, DeallocMem: BOOLEAN):FileIOResult;
VAR f: FileHandlePtr; l: FileLockPtr; actual:LONGINT;
BEGIN
  IF Backup AND (Exists(Name)=fileExists) THEN
    Copy(NewName,Name); Concat(NewName,'.bak');
    IF (Exists(NewName)=fileExists) AND NOT DeleteFile(ADR(NewName)) THEN
      RETURN renameError
    END;
    IF NOT Rename(ADR(Name),ADR(NewName)) THEN
      RETURN renameError
    END;
  END; (* if backup *)
  f:=Open(ADR(Name),newFile);
  IF f#NIL THEN
    actual:=Write(f,Buffer,Len);
    Close(f);
    IF (actual=Len) THEN
      IF DeallocMem THEN Deallocate(Buffer) END;
      RETURN noError;
    ELSE
      RETURN writeError
    END;
  ELSE
    RETURN saveError
  END
END PutFile;

BEGIN
END FileIO.mod
