IMPLEMENTATION MODULE DisAss;
(*$ LargeVars:=FALSE *)
(* Autor:	Bernd Preusing, Gerhardstr. 16, D-2200 Elmshorn
	Copyright:	public domain
	Version:	1.0  02-Okt-88
	Imports:	---
	Cofiles:	Dis68000.asm
	Zweck:	Disassembliere  e i n e n  Befehl nach RECORD Line
	Update:	1.1 08-Feb-89 roxl,roxr und dc.w korrigiert
	:Update.	1.2 09-Feb-90 nach ASSEMBLE konvertiert!!!!!
1.5.90 move ccr,ea eingebaut
24.6.90 extb.l mul/div 32 chk.l trapcc
25.6.90 cleanup bei Line.-Zugriffen, Typ Line erweitert!
16.8.92/bp Fehler FMOVEM = FMOVE behoben
*)


FROM SYSTEM IMPORT ASSEMBLE, ADDRESS;

CONST
	MarkChar=ORD('Q');
VAR
	(*$ LongAlign:=FALSE *)
	OpLen:SHORTINT;
	FFlag:BOOLEAN;
	(*$ LongAlign:=TRUE *)
	LoopRegs: RECORD a2,a0,a7,d6:ADDRESS END;
        CodeStart:ADDRESS;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Disass(Buffer{9},Code{8}:ADDRESS;Offset{0}:LONGINT):ADDRESS;
BEGIN
ASSEMBLE(
(*
 Bernd Preusing, Gerhardstr. 16, D-2200 Elmshorn
 file dis68000.asm
 EING. A0:BEFEHL
 D0=offset
 AUSGANG=D0: NEUER BEFEHL (adr des nchsten)
 A4 frei
 A1=buffer:
 flag bit0 = scheinadresse gltig
 bit 1 pc-relativ mit Lxxxxxx
 bit2 dc.W
*)
	MOVEM.L	D2-D7/A2-A3/A5/A6,-(A7)  (* NEU *)
	MOVEA.L	D0,A6 (* offset fr adresse A0+offset=scheinaddr *)
	CLR.B	FFlag(A4)
	MOVE.L	A7,LoopRegs.a7(A4)
	MOVEQ.L	#Line.s1,D7 (*alt:2 *)
	MOVE.L	A1,D0
	BCLR	#0,D0
	MOVEA.L	D0,A1	(* puffer *)
	MOVE.L	A0,D0
	BCLR	#0,D0
	MOVEA.L	D0,A0	(* code *)
	MOVE.L	D0,CodeStart(A4) (* NEU!! ADR MERKEN *)
	ADD.L	A6,D0 (* scheinaddr *)
	MOVE.L	D0,D2
	MOVEQ.L	#3,D1
	BSR	HexOut	(* adr *)
	MOVE.W	#$2020,0(A1,D7.W) (*NEU *)
	MOVEQ.L	#Line.s2,D7 (* NEU!! *)
	MOVEQ.L	#0,D6
	LEA	CmdTab(PC),A2
	MOVE.W	(A0)+,D0	(* befehl *)
L000001:
	MOVE.W	-2(A0),D0 (* weil MOVEm evtl. bit 10 verndert! *)
	CLR.W	Line.flags(A1)	(* flags lschen *)
	TST.B	FFlag(A4)
	BNE.S	allesdurch
	BSR	FindCmd (* Nr*2 in D6.W *)
	BEQ.S	L000002	(* gefunden *)
allesdurch:
	MOVE.L	#$44432E57,0(A1,D7.W)	(* 'DC.W' *)
	ADDQ.W	#4,D7
	BSR	Tab24
	MOVE.B	#'$',0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.L	D0,D2
	MOVEQ.L	#2,D1
	BSR	HexOut
	BSET	#2,Line.flags+1(A1)
	BRA.S	L000007
L000002:
	MOVE.B	(A2)+,0(A1,D7.W)
	ADDQ.W	#1,D7
	BCLR	#7,-1(A1,D7.W)
	BEQ.S	L000002
	CMPI.B	#32,-1(A1,D7.W)
	BNE.S	L000003
	SUBQ.W	#1,D7
L000003:
	LEA	LoopRegs(A4),A3
	MOVE.L	A2,(A3)+
	MOVE.L	A0,(A3)+
	MOVE.L	A7,(A3)+
	MOVE.L	D6,(A3)+
	BTST	#4,(A2)
	BEQ.S	L000004
	BSR	Tab24
	BRA.S	L000005
L000004:
	BTST	#5,(A2)
	BEQ.S	L000005
	BSR	CalcArgLen
L000005:
	BTST	#6,(A2)
	BEQ.S	L000006
	BSR	PutImm
L000006:
	SUBA.L	A5,A5
	LEA	JmpTab(PC),A3
	ADDA.W	D6,A3
	MOVE.W	(A3),D1
	ADDA.W	D1,A3
	JSR	(A3)
	MOVEA.L	LoopRegs.a2(A4),A2
	MOVE.L	(A2),D1
	MOVE.L	A5,D6
	AND.L	D6,D1
	CMP.L	D6,D1 (* adressierungsarten erlaubt *)
	BNE.S	L000008
L000007:
	MOVE.L	LoopRegs.a7(A4),A7 (* sure is sure! *)
	CLR.B	0(A1,D7.W)
	SUB.W	#Line.s1,D7
	MOVE.W	D7,Line.l(A1)
	MOVE.L	CodeStart(A4),D3 (* ALTE ADR *)
	MOVE.L	D3,D2
	SUB.L	A0,D3
	NEG.L	D3
	MOVEA.L	D2,A0
	ASR.L	#1,D3 (* ANZ WORTE DES CODES *)
	MOVEQ.L	#Line.s1+8,D7 (*HINTER ADDR,SPACES *)
	BRA.S	HEXL
HEX0L:	MOVE.W	(A0)+,D2 (* hexwords ausgeben *)
	MOVEQ	#2,D1
	BSR	HexOut
HEXL:	DBRA	D3,HEX0L
	MOVEQ.L	#Line.s2,D1
	BSR	Spaces
	MOVE.L	A0,D0
	MOVEM.L	(A7)+,D2-D7/A2-A3/A5/A6	(*NEU *)
	RTS

L000008: (* op-fehler *)
	MOVEQ.L	#Line.s2,D7	(* !!! *)
	LEA	LoopRegs(A4),A3
	MOVEA.L	(A3)+,A2
	MOVEA.L	(A3)+,A0
	MOVEA.L	(A3)+,A7
	MOVE.L	(A3)+,D6
	ADDQ.L	#4,A2
	ADDQ.W	#2,D6
	BRA	L000001 (* jetzt DC.W *)

(* long in D2 4 bytres putten *)
PutLong:
	ROL.L	#8,D2
	MOVE.B	D2,0(A1,D7.W)
	ROL.L	#8,D2
	MOVE.B	D2,1(A1,D7.W)
	ROL.L	#8,D2
	MOVE.B	D2,2(A1,D7.W)
	ROL.L	#8,D2
	MOVE.B	D2,3(A1,D7.W)
	ADDQ.L	#4,D7
	RTS
T0:
	BSR	RegChLow
	EXT.W	D1
	EXT.L	D1
	MOVE.L	D1,D2
	BSR	RegChHi
	EXT.W	D1
	EXT.L	D1
	BTST	#3,D0
	BEQ.S	L00000A
	ORI.L	#$2D284100,D2
	BSR	PutLong
	MOVE.L	#$292C2D28,D2	(* '),-(' *)
	BSR	PutLong
	LSL.L	#8,D1
	LSL.L	#8,D1
	ORI.L	#$41002900,D1	(*'A ) ' *)
	MOVE.L	D1,D2
	BSR	PutLong
	SUBQ.W	#1,D7		(* waren nur 11 statt 12! *)
	RTS
L00000A:
	MOVE.B	#'D',0(A1,D7.W)
	MOVE.B	D2,1(A1,D7.W)
	MOVE.B	#',',2(A1,D7.W)	(*',D' *)
	MOVE.B	#'D',3(A1,D7.W)	(*',D' *)
	MOVE.B	D1,4(A1,D7.W)
	ADDQ.W	#5,D7
	RTS

(* ADD,and,or,sub *)
T1:
	MOVEQ.L	#'D',D2
	BSR	RegChHi
	BTST	#8,D0
	BEQ.S	L00000B
	MOVE.W	D0,D3
	ANDI.W	#$38,D3
	BEQ	L000008
	MOVE.B	D2,0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	BSR	PutKomma
	BSR	QuellEA
	MOVE.L	A5,D1
	SWAP	D1
	MOVEA.L	D1,A5
	RTS

L00000B:
	BSR	QuellEA
	BSR	PutKomma
	MOVE.B	D2,0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

T2:
	BTST	#8,D0
	BEQ.S	L00000C
	BSR	PutdL
	MOVE.B	#4,OpLen(A4)
	BRA.S	L00000D
L00000C:
	BSR	PutdW
	MOVE.B	#2,OpLen(A4)
L00000D:
	BSR	Tab24

T30:	MOVEQ.L	#'A',D2
	BSR	RegChHi
	BRA.S	L00000B

T3:	MOVE.B	OpLen(A4),D1
	CMPI.B	#4,D1
	BEQ.S	L00000E
	MOVE.W	(A0)+,D2
	BRA.S	L00000F
L00000E:
	MOVE.L	(A0)+,D2
L00000F:
	BSR	HexOut
	BSR	PutKomma
	BRA	QuellEA

(* ADDQ, SUBQ *)
T4:	BSR	Put0to8
	MOVE.B	D1,-1(A1,D7.W) (* $ lschen *)
	BSR	PutKomma
	BRA	QuellEA

T5:	MOVEQ.L	#1,D1
	MOVE.W	(A0)+,D2
	BSR	HexOut
	BSR	PutKomma
	BRA	L000053

T6:	MOVEQ.L	#2,D1
	MOVE.W	(A0)+,D2
	BSR	HexOut
	BSR	PutKomma
	BRA	L000054

T7:	BTST	#5,D0
	BEQ.S	L000010
	BSR	RegChHi
	MOVE.B	#'D',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	BRA.S	L000011
L000010:
	BSR	PutImm
	BSR	Put0to8
	MOVE.B	D1,-1(A1,D7.W)
L000011:
	BSR	PutKomma
	BSR	RegChLow
	MOVE.B	#'D',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

L000018:
	DC.B	'RASRHILSCCCSNEEQVCVSPLMIGELTGTLE'


(* DBcc und Bcc *)
T8:	MOVE.W	D0,D1
	ANDI.W	#$0F00,D1
	LSR.W	#7,D1
	MOVE.B	L000018(PC,D1.W),0(A1,D7.W)
	MOVE.B	L000018+1(PC,D1.W),1(A1,D7.W)
	ADDQ.W	#2,D7
	CLR.B	D2	(* flag: kein .S *)
	BTST	#13,D0
	BEQ.S	L000015
	MOVE.B	D0,D1
	BEQ.S	L000012
	EXT.W	D1
	MOVE.B	#'.',0(A1,D7.W)
	MOVE.B	#'S',1(A1,D7.W)
	ADDQ.W	#2,D7
	ST	D2
	BRA.S	L000013
L000012:
	MOVE.W	(A0)+,D1
	SUBQ.W	#2,D1
L000013:
	BSR	Tab24
L000014:
	EXT.L	D1
	MOVE.L	A0,-(A7)
	SUBQ.L	#1,A0
	TST.B	D2	(* $FF=shortbra *)
	BNE.S	nurdotS
	SUBQ.L	#1,A0
nurdotS:MOVE.L	A0,Line.adrAdr(A1) (* zeigt GENAU auf Code! *)
	MOVE.L	(A7)+,A0

	MOVE.B	#MarkChar,0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.L	A0,D2
	ADD.L	D1,D2

	MOVE.L	D2,Line.adr(A1) (* wahreadresse eintragen *)
	BSET	#0,Line.flags+1(A1) (* flag setzen *)
	MOVEQ	#-Line.s1-1,D1
	ADD.W	D7,D1
	MOVE.W	D1,Line.adrPos(A1)
	ADD.L	A6,D2
	MOVEQ.L	#3,D1
	BRA	HexOut

L000015:
	TST.B	D1
	BNE.S	L000016
	MOVE.B	#'T',-2(A1,D7.W)
	MOVE.B	#' ',-1(A1,D7.W)
	BRA.S	L000017
L000016:
	CMPI.B	#2,D1
	BNE.S	L000017
	MOVE.B	#'R',-2(A1,D7.W)
	MOVE.B	#'A',-1(A1,D7.W)
L000017:
	BSR	Tab24
	BSR	RegChLow
	MOVE.B	#'D',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	MOVE.B	#',',2(A1,D7.W)
	ADDQ.W	#3,D7
	MOVE.W	(A0)+,D1
	SUBQ.W	#2,D1
	BRA.S	L000014

(* BITs # *)
T9:
	MOVE.W	(A0)+,D2
	MOVEQ.L	#1,D1
	BSR	DezOut
	BSR	PutKomma
	BRA	QuellEA

(* Bits Dx und Eor.x dx,ea *)
T10:	BSR	RegChHi
	MOVE.B	#'D',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	BSR	PutKomma
	BRA	QuellEA

(* nur noch CMP *)
T11:	BSR	RegChHi
	MOVEQ.L	#'D',D2
	BRA	L00000B

(* chk, mulx, divx *)
T11a:
	MOVE.B	#2,OpLen(A4)
	BRA.S	T11
T11b: (* chk.l *)
	MOVE.B	#4,OpLen(A4)
	BRA.S	T11

T12:	BSR	RegChLow
	BSR.S	L000019
	ADDQ.W	#6,D7
	BSR	RegChHi
	BSR.S	L000019
	ADDQ.W	#5,D7
	RTS
L000019:
	MOVE.B	#'(',0(A1,D7.W)
	MOVE.B	#'A',1(A1,D7.W)
	MOVE.B	D1,2(A1,D7.W)
	MOVE.B	#')',3(A1,D7.W)
	MOVE.B	#'+',4(A1,D7.W)
	MOVE.B	#',',5(A1,D7.W)
	RTS

T13:	BSR	RegChLow
	MOVE.B	D1,D2
	BSR	RegChHi
	MOVE.B	D0,D4
	ANDI.B	#$F8,D4
	MOVE.L	#$2C442044,D3	(*',D D' *)
	CMPI.B	#$40,D4
	BEQ.S	L00001A
	MOVE.L	#$2C412041,D3	(*',A A' *)
	CMPI.B	#$48,D4
	BEQ.S	L00001A
	MOVE.B	#'D',D3
	CMPI.B	#$88,D4
	BNE	L000008
L00001A:
	MOVE.B	D3,0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	SWAP	D3
	MOVE.B	#',',2(A1,D7.W)
	MOVE.B	D3,3(A1,D7.W)
	MOVE.B	D2,4(A1,D7.W)
	ADDQ.W	#5,D7
	RTS

GetSU: (* d3 wird dh, d4 wird dl, d2=opword *)
	MOVE.W	(A0)+,D2
	MOVEQ	#'S',D1
	BTST	#11,D2
	BNE.S	sign
	MOVEQ	#'U',D1
sign:
	MOVE.B	D1,0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.W	D2,D3
	ANDI.W	#7,D3
	MOVE.W	D2,D4
	ROL.W	#4,D4
	ANDI.W	#7,D4
	MOVE.B	#4,OpLen(A4)
	RTS

Mul32:
	BSR.S	GetSU
	BTST	#10,D2
	BNE.S	noSmul
	MOVE.W	D4,D3	(* dh wird dl, somit beide gleich *)
noSmul:
	BSR	PutdL
	BSR	Tab24
	BSR	QuellEA
	BSR	PutKomma
	MOVEQ	#'D',D5
	CMP.W	D3,D4
	BEQ.S	regsGleich
	MOVE.B	D5,0(A1,D7.W)
	ADDI.B	#'0',D3
	MOVE.B	D3,1(A1,D7.W)
	MOVE.B	#':',2(A1,D7.W)
	ADDQ.W	#3,D7
regsGleich:
	MOVE.B	D5,0(A1,D7.W)
	ADDI.B	#'0',D4
	MOVE.B	D4,1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

Div32:
	BSR	GetSU
	BTST	#10,D2
	BNE.S	isL
	CMP.W	D3,D4
	BEQ.S	isL
	MOVE.B	#'L',0(A1,D7.W)
	ADDQ.W	#1,D7
isL:
	BRA.S	noSmul



T14:	BTST	#6,D0
	BEQ.S	L00001B
	BSR	PutdL
	BRA.S	L00001C
L00001B:
	BSR	PutdW
L00001C:
	BSR	Tab24
	BSR	RegChLow
	MOVE.B	#'D',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

(*nur link *)
T15:	BSR	RegChLow
	MOVE.B	#'A',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	MOVE.B	#',',2(A1,D7.W)
	MOVE.B	#'#',3(A1,D7.W)
	ADDQ.W	#5,D7	(* # nicht lschen *)
rtd:
	MOVE.W	(A0)+,D2
	MOVEQ.L	#2,D1
	BRA	DezOut


T16:	MOVE.W	D0,D2
	LSR.W	#6,D2
	ANDI.B	#$C0,D2
	MOVEQ.L	#1,D1
	CMPI.B	#$40,D2
	BNE.S	L00001D
	BSR	PutdB
	BRA.S	L00001F
L00001D:
	MOVEQ.L	#2,D1
	CMPI.B	#$C0,D2
	BNE.S	L00001E
	BSR	PutdW
	BRA.S	L00001F
L00001E:
	MOVEQ.L	#4,D1
	CMPI.B	#$80,D2
	BNE	L000008
	BSR	PutdL
L00001F:
	MOVE.B	D1,OpLen(A4)
	BSR	Tab24
	BSR	QuellEA
	BSR	PutKomma
	BRA	ZielEA

T17:
	MOVE.B	#1,OpLen(A4)
	BSR	QuellEA (* MOVE.B to CCR *)
	BSR	PutKomma
	BRA	L000053

T18:
	MOVE.B	#2,OpLen(A4)
	BSR	QuellEA (* MOVE.W to SR *)
	BSR	PutKomma
	BRA	L000054

T19:
	MOVE.B	#2,OpLen(A4)
	BSR	L000054 (* MOVE.W from SR *)
	BSR	PutKomma
	BRA	QuellEA

TMoveCCR:
	(* move.b ccr,ea nur ab 68010! *)
	MOVE.B	#1,OpLen(A4)
	BSR	L000053
	BSR	PutKomma
	BRA	QuellEA

T20:	BSR	RegChLow
	BTST	#3,D0
	BEQ.S	L000020
	BSR.S	L000021
	BSR	PutKomma
	MOVE.B	#'A',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS
L000020:
	MOVE.B	#'A',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	MOVE.B	#',',2(A1,D7.W)
	ADDQ.W	#3,D7
L000021:
	MOVE.B	#'U',0(A1,D7.W)
	MOVE.B	#'S',1(A1,D7.W)
	MOVE.B	#'P',2(A1,D7.W)
	ADDQ.W	#3,D7
	RTS

T21:	BTST	#12,D0 (* MOVEA *)
	BEQ.S	L000022
	MOVEQ.L	#2,D1
	BSR	PutdW
	BRA.S	L000023
L000022:
	MOVEQ.L	#4,D1
	BSR	PutdL
L000023:
	MOVE.B	D1,OpLen(A4)
	BSR	Tab24
	BSR	QuellEA
	BSR	PutKomma
	BSR	RegChHi
	MOVE.B	#'A',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

T22:	BSR.S	L000024 (* MOVEm regs,() *)
	(* nur bei ,-(ax) (mode 100): bit10:=0 *)
	MOVE.L	D1,-(A7)
	MOVE.W	#$0038,D1	(* mode *)
	AND.W	D0,D1
	CMPI.W	#$0020,D1 (* =100 ? *)
	BEQ.S	MOVEmok
	BSET	#10,D0
MOVEmok:
	MOVE.L	(A7)+,D1
	BSR.S	L000028
	BSR	PutKomma
	BRA	QuellEA

T23:	BSR.S	L000024 (* MOVEm (),regs *)
	BSR	QuellEA
	BSR	PutKomma
	BRA.S	L000028

L000024:
	BTST	#6,D0
	BNE.S	L000025
	BSR	PutdW
	BRA.S	L000027
L000025:
	BSR	PutdL
L000027:
	BSR	Tab24
	MOVE.W	(A0)+,D1
	BEQ	L000008
	RTS

L000028:
	MOVEQ.L	#'D',D5
L000029:
	MOVEQ.L	#'/',D2 (* wird 0 *)
	MOVEQ.L	#'.',D3 (* wird / *)
	MOVEQ.L	#7,D4
	CLR.B	D6
L00002A:
	ADDQ.B	#1,D2
	ADDQ.B	#1,D3
	BTST	#10,D0 (* richtung MOVEm *)
	BNE.S	L00002B
	ROL.W	#1,D1
	BRA.S	L00002C
L00002B:
	ROR.W	#1,D1
L00002C:
	BCC.S	L00002E
	TST.B	D6
	BNE.S	L00002D
	MOVE.B	D5,0(A1,D7.W) (* D od. A *)
	MOVE.B	D2,1(A1,D7.W) (* reg-nr *)
	ADDQ.W	#2,D7
L00002D:
	ADDQ.B	#1,D6
	BRA.S	L000030
L00002E:
	TST.B	D6
	BEQ.S	L000030
	CMPI.B	#1,D6
	BEQ.S	L00002F
	MOVE.B	#'-',0(A1,D7.W)
	MOVE.B	D5,1(A1,D7.W)
	MOVE.B	D3,2(A1,D7.W)
	ADDQ.W	#3,D7
L00002F:
	MOVE.B	#'/',0(A1,D7.W)
	ADDQ.W	#1,D7
	CLR.B	D6
L000030:
	DBF	D4,L00002A(PC)
	CMPI.B	#1,D6
	BLE.S	L000031
	MOVE.B	#'-',0(A1,D7.W)
	MOVE.B	D5,1(A1,D7.W)
	MOVE.B	D2,2(A1,D7.W)
	ADDQ.W	#3,D7
L000031:
	CMPI.B	#'D',D5
	BNE.S	L000032
	MOVEQ.L	#'A',D5
	CMPI.B	#'/',-1(A1,D7.W)
	BEQ.S	TestD
	MOVE.B	#'/',0(A1,D7.W)
	ADDQ.B	#1,D7
TestD:
	CMPI.B	#'D',-3(A1,D7.W) (* D-Reg gezeigt? *)
	BEQ.S	jaok (* ja, ok *)
	SUBQ.W	#1,D7 (* nein, / wieder lschen *)
jaok:
	BRA	L000029

L000032:
	CMPI.B	#'/',-1(A1,D7.W)
	BNE.S	L000033
	SUBQ.W	#1,D7 (* letzen / lschen *)
L000033:
	RTS


T24:	BTST	#6,D0 (* MOVEp *)
	BNE.S	L000034 (* langwort *)
	BSR	PutdW
	BRA.S	L000035
L000034:
	BSR	PutdL
L000035:
	BSR	Tab24	(* neu!! *)
	BSR	RegChLow
	MOVE.B	D1,D3
	BTST	#7,D0
	BNE.S	L000038 (* reg nach mem *)
	BSR	L000042
L000036:
	BSR	PutKomma
L000037:
	BSR	RegChHi
	MOVE.B	#'D',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS
L000038:
	BSR.S	L000037
	BSR	PutKomma
	BRA	L000042

(* MOVEQ *)
T25:	MOVE.B	D0,D2
	MOVEQ.L	#1,D1
	BSR	DezOut
	BRA.S	L000036

T26: (* Scc *)
	BSR	PutCond
	BSR	Tab24
	BRA	QuellEA

PutFReg10:
	MOVE.W	D1,D2
	ROL.W	#6,D2
	BRA.S	PutFReg2
PutFReg7:
	MOVE.W	D1,D2
	LSR.W	#7,D2
	BRA.S	PutFReg2
PutFReg:
	MOVE.B	D0,D2
PutFReg2:
	ANDI.B	#$07,D2
	ORI.B	#$30,D2
	MOVE.B	#'F',0(A1,D7.W)
	MOVE.B	#'P',1(A1,D7.W)
	MOVE.B	D2,2(A1,D7.W)
	ADDQ.W	#3,D7
	RTS

Ftrapcc:
PutFCond:
	MOVE.W	(A0)+,D1
PutFCond2:
	MOVE.W	D1,D2
	ANDI.W	#$FFE0,D2
	BNE	L000008 (* err *)
	ANDI.W	#$001F,D1
	ADD.W	D1,D1
	ADD.W	D1,D1
	LEA	Fconds(PC,D1.W),A3
	MOVEQ	#3,D3
flp:	MOVE.B	(A3)+,0(A1,D7.W)
	ADDQ.W	#1,D7
	DBRA	D3,flp
flp2:	CMPI.B	#' ',-1(A1,D7.W)
	BNE.S	flpr
	SUBQ.W	#1,D7
	BRA.S	flp2
flpr:	BSR	Tab24
	RTS

Fconds:
   DC.B	'F   EQ  OGT OGE OLT OLE OGL OR  UN  UEQ UGT UGE ULT ULE NE  T   '
   DC.B	'SF  SEQ GT  GE  LT  LE  GL  GLE NGLENGL NLE NLT NGE NGT SNE ST  '

PutFCondThis:
	MOVE.W	D0,D1
	ANDI.W	#$001F,D1
	BRA	PutFCond2

Fscc:	BSR	PutFCond
	BRA	QuellEA

Ftrapcc16:
	BSR	PutFCond
	BRA	cc16
Ftrapcc32:
	BSR	PutFCond
	BRA	cc32

Fdbcc:	MOVE.W	D0,-(A7)
	MOVE.W	(A0)+,D0
	BSR	PutFCondThis
	MOVE.W	(A7)+,D0
	MOVE.B	#'D',0(A1,D7.W)
	ANDI.B	#7,D0
	ADDI.B	#$30,D0
	MOVE.B	D0,1(A1,D7.W)
	ADDQ.W	#2,D7
	BSR	PutKomma
Fdbcc1:
	MOVE.W	(A0)+,D1
	SUBQ.W	#2,D1
	MOVEQ	#0,D2 (* flag: kein .S *)
	BRA	L000014

Fbcc:	MOVE.W	D0,D2 (* ist es FNOP ? *)
	ANDI.W	#$001F,D2
	BNE.S	nofnop
	MOVE.W	(A0),D1
	BNE.S	nofnop
	ADDQ.L	#2,A0
	SUBQ.W	#2,D7
	MOVE.L	#$464E4F50,D2
	BSR	PutLong
	RTS
nofnop:	BSR	PutFCondThis
	BRA.S	Fdbcc1

FSizeTab:
	DC.B	'LSXPWDB?' (* ? ist .P ea{k} *)
FOpTab: (* Bytes bei #imm *)
	DC.B	4,4,12,12,2,8,1,12

PutFSize:
	MOVE.W	D1,D2
	ROL.W	#6,D2
	ANDI.W	#7,D2
PutFs:
	MOVE.B	#'.',0(A1,D7.W)
	MOVE.B	FSizeTab(PC,D2.W),1(A1,D7.W)
	MOVE.B	FOpTab(PC,D2.W),OpLen(A4)
	ADDQ.W	#2,D7
	BSR	Tab24
	RTS

fmovetofp:
fdyad:	ST	D3
	BRA.S	fmona1
fmona:	MOVEQ	#0,D3
fmona1:	MOVE.W	D1,D2
	BTST	#14,D2
	BEQ.S	nofea
	BSR	PutFSize
	BSR	QuellEA
	BSR	PutKomma
	BSR	PutFReg7
	RTS
nofea:	ANDI.W	#$003F,D0
	BNE	L000008 (* err! *)
	MOVEQ	#2,D2
	BSR	PutFs (* .X ausgeben! *)
	BSR	PutFReg10
	BSR	PutKomma
	BSR	PutFReg7
	TST.B	D3
	BNE.S	nofsing
	MOVE.W	D1,D2
	LSR.W	#7,D2
	ROL.W	#6,D1
	ANDI.B	#7,D1
	ANDI.B	#7,D2
	CMP.B	D1,D2
	BNE.S	nofsing
	SUBQ.W	#4,D7
nofsing:
	RTS

fsincos:
	BSR	fmona
	MOVE.W	D1,D2
	ANDI.B	#7,D2
	ORI.B	#$30,D2
	MOVE.B	D2,-1(A1,D7.W)
	MOVE.B	#':',0(A1,D7.W)
	ADDQ.W	#1,D7
	BSR	PutFReg7
	RTS

fmovecr:ANDI.W	#$3F,D0 (* TAb24 und #$ schon da! *)
	BNE	L000008 (* err! *)
	MOVE.W	D1,D2
	MOVE.L	D1,-(A7)
	ANDI.W	#$001F,D2
	MOVEQ	#1,D1
	BSR	HexOut
	MOVE.L	(A7)+,D1
	BSR	PutKomma
	BSR	PutFReg7
	RTS

PutCR:	MOVE.W	D1,D3
	ROL.W	#6,D3
	ANDI.W	#7,D3
	BCLR	#2,D3
	BEQ.S	noFPCR
	MOVE.L	#$46504352,D2 (* FPCR *)
	BSR	PutLong
	TST.W	D3
	BEQ.S	PutCRRdy
	MOVE.B	#'/',0(A1,D7.W)
	ADDQ.W	#1,D7
noFPCR:	BCLR	#1,D3
	BEQ.S	noFPSR
	MOVE.L	#$46505352,D2 (* FPSR *)
	BSR	PutLong
	TST.W	D3
	BEQ.S	PutCRRdy
	MOVE.B	#'/',0(A1,D7.W)
	ADDQ.W	#1,D7
noFPSR:
	BCLR	#0,D3
	BEQ.S	PutCRRdy
	MOVE.L	#$46504941,D2 (* FPIAR *)
	BSR	PutLong
	MOVE.B	#'R',0(A1,D7.W)
	ADDQ.W	#1,D7
PutCRRdy:
	RTS

fmovefpcr:
fmovemfpcr:
	MOVE.B	#4,OpLen(A4)
	BTST	#13,D1
	BEQ.S	featocr
(* fcrtoea: *)
	BSR	PutCR
	BSR	PutKomma
	BSR	QuellEA
	RTS
featocr:
	BSR	QuellEA
	BSR	PutKomma
	BSR	PutCR
	RTS

FList:	BTST	#11,D1
	BEQ.S	statlist
	MOVE.W	D1,D2
	LSR.W	#4,D2
	BSR	PutFReg2
	RTS
statlist:
	MOVE.W	D1,D2
	BTST	#12,D1
	BNE.S	noreverse
	MOVEQ	#7,D3
revlp:	ROXR.B	#1,D1
	ROXL.B	#1,D2
	DBRA	D3,revlp
noreverse: (* liste nun falschrum in D2.B bit 7 ist fp0!! *)
	MOVEQ	#7,D3
	MOVEQ	#'0',D4
flilp:	BCLR	D3,D2
	BEQ.S	noflist
	MOVE.B	#'F',0(A1,D7.W)
	MOVE.B	#'P',1(A1,D7.W)
	MOVE.B	D4,2(A1,D7.W)
	ADDQ.W	#3,D7
	TST.B	D2
	BEQ.S	flistrdy
	MOVE.B	#'/',0(A1,D7.W)
	ADDQ.W	#1,D7
noflist:ADDQ.B	#1,D4
	DBRA	D3,flilp
flistrdy:
	RTS

fmovem: BTST	#13,D1
	BNE.S	fmovemtomem
(* fmovemtomem *)
	BSR	QuellEA
	BSR	PutKomma
	BSR	FList
	RTS
fmovemtomem:
	BSR	FList
	BSR	PutKomma
	BSR	QuellEA
	RTS

fmovetoea:
	BSR	PutFSize
	BSR	PutFReg7
	BSR	PutKomma
	BSR	QuellEA (* .P Fpx,ea{Dn} fehlt noch! *)
	RTS



(* alle restlichen Fxxxx *)
Fall:	ST	FFlag(A4)
	MOVE.W	(A0)+,D1
	LEA	FCmdTab(PC),A2
	MOVEQ	#0,D6
Finf0:	TST.W	(A2)
	BEQ	L000008
	MOVE.W	D1,D2
	AND.W	(A2)+,D2
	CMP.W	(A2)+,D2
	BEQ.S	FFound
Finf1:	BTST	#7,(A2)+
	BEQ.S	Finf1
	ADDQ.L	#4,A2
	ADDQ.W	#2,D6
	BRA.S	Finf0
FFound:	MOVE.B	(A2)+,0(A1,D7.W)
	ADDQ.W	#1,D7
	BCLR	#7,-1(A1,D7.W)
	BEQ.S	FFound
	CMPI.B	#' ',-1(A1,D7.W)
	BNE.S	FFoun1
	SUBQ.W	#1,D7
FFoun1:	MOVE.L	A2,LoopRegs.a2(A4)
	MOVE.B	(A2),D3
	BTST	#4,D3
	BEQ.S	fno1
	BSR	Tab24
fno1:	BTST	#6,D3
	BEQ.S	fno2
	BSR	PutImm
fno2:	LEA	FJumpTab(PC),A3
	ADDA.W	D6,A3
	MOVE.W	(A3),D2
	ADDA.W	D2,A3
	JSR	(A3)
	RTS


L000039:
	DC.B	'T F HILSCCCSNEEQVCVSPLMIGELTGTLE'

PutCond:
Trapcc0:
	MOVE.W	D0,D1
	LSR.W	#7,D1
	ANDI.W	#$001E,D1
	MOVE.B	L000039(PC,D1.W),0(A1,D7.W)
	MOVE.B	L000039+1(PC,D1.W),1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

Trapcc2:
	BSR	PutCond
	BSR	PutdL
	BSR	Tab24
cc32:
	BSR	PutImm
	MOVEQ	#4,D1
	MOVE.L	(A0)+,D2
	BRA	HexOut

Trapcc1:
	BSR	PutCond
	BSR	PutdW
	BSR	Tab24
cc16:
	BSR	PutImm

T27:
	MOVE.W	(A0)+,D2
	MOVEQ.L	#2,D1
	BRA	HexOut

(*TRAP *)
T28:
	MOVE.B	D0,D2
	ANDI.B	#$0F,D2
	MOVEQ.L	#1,D1
	BSR	DezOut
	RTS

(*UNLK *)
T29:	BSR	RegChLow
	MOVE.B	#'A',0(A1,D7.W)
	MOVE.B	D1,1(A1,D7.W)
	ADDQ.W	#2,D7

DUMMY:	RTS


QuellEA:
	MOVEM.L	D0-D6,-(A7)
	MOVE.L	A5,D6
	MOVE.B	D0,D1
	BSR.S	L00003D
	SWAP	D6
	MOVEA.L	D6,A5
	MOVEM.L	(A7)+,D0-D6
	RTS

ZielEA:
	MOVEM.L	D0-D6,-(A7)
	MOVE.L	A5,D6
	MOVE.W	D0,D1
	LSR.W	#8,D1
	LSR.W	#1,D1
	ANDI.W	#7,D1
	MOVE.W	D0,D2
	LSR.W	#3,D2
	ANDI.W	#$38,D2
	OR.W	D2,D1
	BSR.S	L00003D
	SWAP	D6
	MOVEA.L	D6,A5
	MOVEM.L	(A7)+,D0-D6
	RTS

L00003D:
	MOVE.W	#$0800,D6
	MOVE.B	D1,D2
	MOVE.B	D1,D3
	ANDI.B	#7,D3
	ADDI.B	#'0',D3
	MOVEQ.L	#'D',D4
	ANDI.B	#$38,D1 (* mode=0? *)
	BEQ.S	L00003E (* ddir *)
	LSR.W	#1,D6
	MOVEQ.L	#'A',D4
	CMPI.B	#8,D1
	BEQ.S	L00003E (* adir *)
	LSR.W	#1,D6
	CMPI.B	#$10,D1 (* aidr *)
	BEQ.S	L00003F
	LSR.W	#1,D6
	CMPI.B	#$18,D1 (* ainc *)
	BEQ	L000040
	LSR.W	#1,D6
	CMPI.B	#$20,D1 (* adec *)
	BEQ	L000041
	LSR.W	#1,D6
	CMPI.B	#$28,D1 (* d16(an) *)
	BEQ	L000042
	LSR.W	#1,D6
	CMPI.B	#$30,D1 (* d8(an,xn *)
	BEQ	L000043
			(* ab hier 111 *)
	LSR.W	#1,D6
	ANDI.B	#7,D2
	BEQ	L000048 (* absW *)
	LSR.W	#1,D6
	CMPI.B	#1,D2
	BEQ	L00004B (* absL *)
	LSR.W	#1,D6
	CMPI.B	#2,D2
	BEQ	L00004C (* d16(pc) *)
	LSR.W	#1,D6
	CMPI.B	#3,D2
	BEQ	L00004E (* d8(pc,rx) *)
	LSR.W	#1,D6
	CMPI.B	#4,D2
	BEQ	L00004F (* imm *)
	BRA	L000008 (* err *)

(* Dn, An *)
L00003E:
	MOVE.B	D4,0(A1,D7.W)
	MOVE.B	D3,1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

(* (An) *)
L00003F:
	MOVE.B	#'(',0(A1,D7.W)
	MOVE.B	#'A',1(A1,D7.W)
	MOVE.B	D3,2(A1,D7.W)
	MOVE.B	#')',3(A1,D7.W)
	ADDQ.W	#4,D7
	RTS

(* (An)+ *)
L000040:
	BSR.S	L00003F
	MOVE.B	#'+',0(A1,D7.W)
	ADDQ.W	#1,D7
	RTS

(* -(An) *)
L000041:
	MOVE.B	#'-',0(A1,D7.W)
	ADDQ.W	#1,D7
	BRA.S	L00003F

SetDataFlags:
	MOVEQ	#-Line.s1,D1
	ADD.W	D7,D1
	BSET	#3,Line.flags+1(A1)
	BNE.S	war3	(* war schon besetzt, also bit 4 nehmen! *)
	MOVE.W	D1,Line.drelPos1(A1)
	MOVE.L	A0,Line.drelAdr1(A1)
	BRA.S	ist4
war3:	BSET	#4,Line.flags+1(A1)
	MOVE.W	D1,Line.drelPos2(A1)
	MOVE.L	A0,Line.drelAdr2(A1)
ist4:	RTS

(* d16(An) *)
L000042:
	BSR	SetDataFlags
	ADDQ.W	#1,D7
	MOVE.W	(A0)+,D2
	MOVEQ.L	#2,D1
	BSR	DezOut
	BRA.S	L00003F


PutIndex: (* Wort in D2,wird nicht verndert, Bits 8..10 in D4,wird verndert*)
	MOVEM.W	D4/D3,-(A7)
	MOVEQ.L	#'D',D3
	BTST	#15,D2
	BEQ.S	L000045
	MOVEQ.L	#'A',D3
L000045:
	MOVE.B	D3,0(A1,D7.W)
	MOVE.W	D2,D3
	ANDI.W	#$7000,D3
	LSR.W	#8,D3
	LSR.W	#4,D3
	ADDI.B	#'0',D3
	MOVE.B	D3,1(A1,D7.W)
	ADDQ.W	#2,D7
	BTST	#11,D2
	BEQ.S	L000046
	BSR	PutdL
	BRA.S	L000047
L000046:
	BSR	PutdW
L000047:
	MOVE.W	D2,D4
	ANDI.W	#$0700,D4
	BEQ.S	shortRdy (* war nix spezielles *)
	MOVE.B	#'*',0(A1,D7.W)
	LSR.W	#8,D4
	LSR.W	#1,D4
	MOVEQ	#3,D3
	AND.L	D3,D4 (* 0..3 Scale *)
	MOVEQ	#1,D3
	LSL.W	D4,D3 (* gibt 1,2,4,8 *)
	ADDI.B	#'0',D3
	MOVE.B	D3,1(A1,D7.W)
	ADDQ.W	#2,D7
shortRdy:
	MOVEM.W	(A7)+,D4/D3
	RTS

(* d8(An,Rn.x) und der ganze 68020..-Kram, L00004E fr (PC..)!!!*)
(* d3 hat voriges wort and 7 +30H also regchar *)
L000043:
	MOVE.W	(A0)+,D2
	MOVE.W	D2,D4	(* test, ob 68020.. *)
	ANDI.W	#$0700,D4 (* scale#0 oder bit8#0 *)
	BEQ	normIdx (* normales d8(ax,Rx.w) *)
	MOVE.B	#'(',0(A1,D7.W)
	ADDQ.W	#1,D7
	BTST	#8,D4
	BEQ	shortForm

(* D3 hat Registernummer als ASCII oder o, wenn PCidx! *)
(* 1.: bd []!!?? *)
	MOVE.W	D2,D4 (* indirekt? *)
	ANDI.W	#$7,D4
	BEQ.S	noIndir
	MOVE.B	#'[',0(A1,D7.W)
	ADDQ.W	#1,D7
noIndir:
	MOVE.W	D2,D4
	ANDI.W	#$0030,D4
	(* 0 und 1: nix 1:word 2:long *)
	CMPI.W	#$0010,D4
	BLE.S	noBD
	BSR	SetDataFlags
	MOVE.W	D2,-(A7)
	MOVE.B	#'$',0(A1,D7.W)
	ADDQ.W	#1,D7
	CMPI.W	#$20,D4
	BNE.S	longBD
	MOVE.W	(A0)+,D2
	MOVEQ	#2,D1
	BSR	DezOut
	BRA.S	contBD
longBD:	MOVE.L	(A0)+,D2
	MOVEQ	#4,D1
	BSR	HexOut
contBD:	MOVE.W	(A7)+,D2
	BSR	PutKomma (* was, wenn nix mehr kommt? *)
noBD:	TST.B	D3	(* 0=pc! *)
	BNE.S	nopcIdx
	BTST	#7,D2
	BEQ.S	nopcIdxSuppression
	MOVE.B	#'Z',0(A1,D7.W)
	ADDQ.W	#1,D7
nopcIdxSuppression:
	MOVE.B	#'P',0(A1,D7.W)
	MOVE.B	#'C',1(A1,D7.W)
	ADDQ.W	#2,D7
	BRA.S	BaseReg
nopcIdx:
	BTST	#7,D2
	BNE.S	noBaseReg
	MOVE.B	#'A',0(A1,D7.W)
	MOVE.B	D3,1(A1,D7.W)
	ADDQ.W	#2,D7
BaseReg:BSR	PutKomma
noBaseReg:
	BTST	#2,D2
	BEQ.S	preIndex
	MOVE.B	#']',-1(A1,D7.W) (* Komma berschreiben *)
	BSR	PutKomma
preIndex:
	BTST	#6,D2
	BNE.S	indexSuppr
	BSR	PutIndex
	BSR	PutKomma
indexSuppr:
	BTST	#2,D2
	BNE.S	postIdx
	MOVE.W	D2,D4
	ANDI.W	#7,D4 (* berhaupt indirekt? *)
	BEQ.S	postIdx
	MOVE.B	#']',-1(A1,D7.W)
	BSR	PutKomma
postIdx:
(* nun noch od: *)
	MOVE.W	D2,D4
	ANDI.W	#3,D4
	CMPI.W	#1,D4
	BLE.S	noOD
	MOVE.W	D2,-(A7)
	CMPI.W	#2,D4
	BNE.S	longOD
	MOVE.B	#'$',0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.W	(A0)+,D2
	MOVEQ	#2,D1
	BSR	DezOut
	BRA.S	Putod
longOD:	MOVE.L	(A0)+,D2
	MOVEQ	#4,D1
	BSR	HexOut
Putod:	MOVE.W	(A7)+,D2
	BSR	PutKomma
noOD:	CMPI.B	#',',-1(A1,D7.W)
	BNE.S	noODok
	SUBQ.W	#1,D7
noODok:
	MOVE.B	#')',0(A1,D7.W)
	ADDQ.W	#1,D7
	RTS	(* wird sind fertig! *)

shortForm:
	MOVEQ	#1,D1
	ADDQ.W	#1,D7
	BSR	DezOut
	BSR	PutKomma
	MOVE.B	#'A',0(A1,D7.W)
	MOVE.B	D3,1(A1,D7.W) (* AregNr *)
	ADDQ.W	#2,D7
	BSR	PutKomma
	BRA.S	normCont

normIdx:
	MOVEQ.L	#1,D1
	ADDQ.W	#1,D7
	BSR	DezOut (* lowbyte=offset *)
	BSR	L00003F (* (Ad3) *)

(* Achtung: Sprungziel von d8(PC,Rx.s) ! *)
L000044:
	MOVE.B	#',',-1(A1,D7.W) (* setze , statt ) *)

normCont:
	BSR	PutIndex
	MOVE.B	#')',0(A1,D7.W)
	ADDQ.W	#1,D7
	RTS

(* $xxxx *)
L000048:MOVEQ.L	#2,D1
L000049:MOVE.W	(A0)+,D2
L00004A:MOVE.B	#'$',0(A1,D7.W)
	ADDQ.W	#1,D7
	BRA	HexOut

SetAbsM1:
	MOVEQ	#-Line.s1-1,D1
	BRA.S	SetAb2
SetAbs:	MOVEQ	#-Line.s1,D1
SetAb2:	ADD.W	D7,D1
	BSET	#5,Line.flags+1(A1)
	BNE.S	abs1b
	MOVE.L	A0,Line.abslAdr1(A1)
	MOVE.W	D1,Line.abslPos1(A1)
	BRA.S	abs2b
abs1b:	BSET	#6,Line.flags+1(A1)
	MOVE.L	A0,Line.abslAdr2(A1)
	MOVE.W	D1,Line.abslPos2(A1)
abs2b:	RTS

(* $xxxxxxxx *)
L00004B:
	BSR.S	SetAbs
	MOVE.L	(A0)+,D2
	MOVEQ.L	#4,D1
	BRA.S	L00004A

(* d16(PC) *)
L00004C:
	MOVE.B	#MarkChar,0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.L	A0,Line.adrAdr(A1)
	MOVE.W	(A0)+,D2
	EXT.L	D2
	ADD.L	A0,D2
	SUBQ.L	#2,D2
	MOVE.L	D2,Line.adr(A1)
	BSET	#1,Line.flags+1(A1)
	MOVEQ	#-Line.s1-1,D1
	ADD.W	D7,D1
	MOVE.W	D1,Line.adrPos(A1)
	ADD.L	A6,D2
	MOVEQ.L	#3,D1
	BSR	HexOut

L00004D:
	MOVE.B	#'(',0(A1,D7.W)
	MOVE.B	#'P',1(A1,D7.W)
	MOVE.B	#'C',2(A1,D7.W)
	MOVE.B	#')',3(A1,D7.W)
	ADDQ.W	#4,D7
	RTS

(* d8(PC,Rx.x) *)
L00004E:
	MOVE.W	(A0),D2
	ANDI.W	#$0100,D2
	BEQ	normalPC (* stallt dann eben label(Pc,Rx.w*scale) dar! *)
(* und die ganze Scheie von vorne! *)
	MOVE.W	(A0)+,D2
	MOVE.B	#'(',0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVEQ	#0,D3 (* Flag: ist PC statt Areg *)
	MOVE.W	D2,D4 (* indirekt? *)
	ANDI.W	#$7,D4
	BEQ.S	noIndir2
	MOVE.B	#'[',0(A1,D7.W)
	ADDQ.W	#1,D7
noIndir2:
	MOVE.W	D2,D4
	ANDI.W	#$0030,D4
	(* 0 und 1: nix 1:word 2:long *)
	CMPI.W	#$0010,D4
	BLE.S	noBD2
	MOVE.W	D2,-(A7)
	CMPI.W	#$20,D4
	BNE.S	longBD2
(* nun Wort, also sauber pcrelativ *)
	MOVE.B	#MarkChar,0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.L	A0,Line.adrAdr(A1)
	MOVE.W	(A0)+,D2
	EXT.L	D2
	ADD.L	A0,D2
	SUBQ.L	#4,D2 (* hier -4 (PC=1. ExtWord) statt -2!! *)
	MOVE.L	D2,Line.adr(A1)
	BSET	#1,Line.flags+1(A1)
	MOVEQ	#-Line.s1-1,D1
	ADD.W	D7,D1
	MOVE.W	D1,Line.adrPos(A1)
	ADD.L	A6,D2
	MOVEQ	#3,D1
	BSR	HexOut
	BRA.S	contBD2
longBD2:MOVE.B	#'$',0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.L	(A0)+,D2
	MOVEQ	#4,D1
	BSR	HexOut
contBD2:MOVE.W	(A7)+,D2
	BSR	PutKomma (* was, wenn nix mehr kommt? *)
noBD2:	BRA	noBD (* weiter wie abidx *)

normalPC:
	MOVE.B	#MarkChar,0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.W	(A0),D2
	EXT.W	D2
	EXT.L	D2
	ADD.L	A0,D2

	MOVE.L	D2,Line.adr(A1)
	BSET	#1,Line.flags+1(A1)
	MOVEQ	#-Line.s1-1,D1
	ADD.W	D7,D1
	MOVE.W	D1,Line.adrPos(A1)
	MOVE.L	A0,Line.adrAdr(A1)
	ADDQ.L	#1,Line.adrAdr(A1) (* rel8 ist im low-byte! *)
	MOVEQ.L	#3,D1
	ADD.L	A6,D2
	BSR	HexOut
	BSR	L00004D
	MOVE.W	(A0)+,D2
	MOVEQ	#0,D4	(* Flag: normale 68000 Adressierung *)
	MOVEQ	#0,D3 (* Flag:PCidx *)
	BRA	L000044

(* #$xxxx od. #$xxxxxxxx *)
L00004F:
	BSR.S	PutImm
	MOVE.B	OpLen(A4),D1
	CMPI.B	#8,D1
	BLT.S	max4
hexlp8: (* fr fmove.D oder fmove.x oder fmove.p *)
	MOVE.L	D1,-(A7)
	MOVE.L	(A0)+,D2
	MOVEQ	#4,D1
	BSR	HexOut
	MOVE.L	(A7)+,D1
	SUBQ.B	#4,D1
	BNE.S	hexlp8
	RTS

max4:	CMPI.B	#4,D1
	BEQ.S	L000051
	MOVE.W	(A0)+,D2
L000050:
	BRA	HexOut

L000051:
	BSR	SetAbsM1
	MOVEQ	#4,D1
	MOVE.L	(A0)+,D2
	BRA.S	L000050


Tab24:	MOVE.B	#' ',0(A1,D7.W)
	ADDQ.W	#1,D7
	MOVE.L	D1,-(A7)
	MOVEQ.L	#Line.s2+8,D1
	BSR	Spaces
	MOVE.L	(A7)+,D1
	RTS

L000053:
	MOVE.B	#'C',0(A1,D7.W)
	MOVE.B	#'C',1(A1,D7.W)
	MOVE.B	#'R',2(A1,D7.W)
	ADDQ.W	#3,D7
	RTS

L000054:
	MOVE.B	#'S',0(A1,D7.W)
	MOVE.B	#'R',1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

PutKomma:
	MOVE.B	#',',0(A1,D7.W)
	ADDQ.W	#1,D7
	RTS

PutImm:
	MOVE.B	#'#',0(A1,D7.W)
	MOVE.B	#'$',1(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

Put0to8:
	MOVE.W	D0,D1
	LSR.W	#8,D1
	LSR.W	#1,D1
	ANDI.B	#7,D1
	ADDI.B	#'0',D1
	CMPI.B	#'0',D1
	BNE.S	L000058
	MOVEQ.L	#'8',D1
L000058:
	RTS

CalcArgLen:
	MOVEM.L	D1/A0,-(A7)
	MOVE.B	D0,D1
	ANDI.B	#$0C0,D1
	BEQ.S	L00005A
	CMPI.B	#$040,D1
	BEQ.S	L00005B
	CMPI.B	#$080,D1
	BEQ.S	L00005C
	BRA	L000008
L00005A:
	BSR.S	PutdB
	MOVEQ.L	#1,D1
	BRA.S	L00005D
L00005B:
	BSR.S	PutdW
	MOVEQ.L	#2,D1
	BRA.S	L00005D
L00005C:
	BSR.S	PutdL
	MOVEQ.L	#4,D1
L00005D:
	BSR	Tab24
	MOVE.B	D1,OpLen(A4)
	MOVEM.L	(A7)+,D1/A0
	RTS

PutdB:
	MOVE.B	#'B',1(A1,D7.W)
	BRA.S	L000062
PutdW:
	MOVE.B	#'W',1(A1,D7.W)
	BRA.S	L000062
PutdL:
	MOVE.B	#'L',1(A1,D7.W)
L000062:
	MOVE.B	#'.',0(A1,D7.W)
	ADDQ.W	#2,D7
	RTS

RegChLow:
	MOVE.W	D0,D1
	BRA.S	L000065
RegChHi:
	MOVE.W	D0,D1
	LSR.W	#8,D1
	LSR.W	#1,D1
L000065:
	ANDI.W	#$0007,D1
	ADDI.B	#48,D1
	RTS

FindCmd:
	TST.W	(A2)
	BEQ.S	L000068
	MOVE.W	D0,D1
	AND.W	(A2)+,D1
	CMP.W	(A2)+,D1
	BEQ.S	L000069
L000067:
	BTST	#7,(A2)+
	BEQ.S	L000067
	ADDQ.L	#4,A2
	ADDQ.W	#2,D6
	BRA.S	FindCmd
L000068:
	MOVEQ.L	#1,D1
	RTS
L000069:
	MOVEQ.L	#0,D1
	RTS

(* d1=Anz bytes D2=wert *)
HexOut:
	MOVEM.L	D0-D2/A0,-(A7)
	EXT.W	D1
	BLE.S	Hex0 (* kann vorkommen, bei illEA!! *)
	MOVE.L	D2,D0
	LEA	L000070(PC),A0
	MOVE.W	D1,-(A7)
	SUBQ.W	#4,D1
	BEQ.S	L00006C (* 4 bytes, ok *)
L00006B:
	ROL.L	#8,D0
	ADDQ.W	#1,D1
	BNE.S	L00006B (* nach links schieben *)
L00006C:
	MOVE.W	(A7)+,D1
	SUBQ.W	#1,D1
L00006D:
	BSR.S	L00006E (*nibble *)
	BSR.S	L00006E
	DBF	D1,L00006D(PC)
Hex0:	MOVEM.L	(A7)+,D0-D2/A0
	RTS
L00006E:
	ROL.L	#4,D0
	MOVE.B	D0,D2
	ANDI.W	#15,D2
	MOVE.B	0(A0,D2.W),0(A1,D7.W)
	ADDQ.W	#1,D7
	RTS

L000070:
	DC.B	'0123456789ABCDEF'

(* D1=1 OD. 2 BYTES D2=WERT *)
DezOut:
	MOVEM.L	D2-D3,-(A7)
	SUBQ.W	#1,D7	(* $ LSCHEN *)
	MOVEQ	#0,D3
	CMPI.B	#1,D1
	BNE.S	PutWord
	EXT.W	D2
PutWord:
	BTST	#15,D2
	BEQ.S	Positiv
	MOVE.B	#'-',0(A1,D7.W)
	ADDQ.W	#1,D7
	NEG.W	D2
Positiv:
	EXT.L	D2
	DIVU	#10000,D2 (* /10000 *)
	BSR.S	PutZiff
	SWAP	D2	(* rest *)
	EXT.L	D2
	DIVU	#1000,D2	(* /1000 *)
	BSR.S	PutZiff
	SWAP	D2
	EXT.L	D2
	DIVU	#100,D2
	BSR.S	PutZiff
	SWAP	D2
	EXT.L	D2
	DIVU	#10,D2
	BSR.S	PutZiff
	MOVEQ	#1,D3
	SWAP	D2
	BSR.S	PutZiff
	MOVEM.L	(A7)+,D2-D3
	RTS

PutZiff:
	BEQ.S	ziff1
	MOVEQ	#1,D3
ziff1:
	TST.L	D3
	BEQ.S	ziff2
	ADDI.B	#'0',D2
	MOVE.B	D2,0(A1,D7.W)
	ADDQ.W	#1,D7
ziff2:
	RTS

(*
Spaces:	MOVE.B	#32,0(A1,D7.W)
	ADDQ.W	#1,D7
	CMP.W	D1,D7
	BLT.S	Spaces
*)
Spaces:	CMP.W	D1,D7
	BGE.S	SpacR
	MOVE.B	#' ',0(A1,D7.W)
	ADDQ.W	#1,D7
	BRA.S	Spaces
SpacR:	RTS

FJumpTab:
	DC.W	fmovecr-* (* fmovecr.x #imm,fpn *)
	DC.W	fmona-* (* fint *)
	DC.W	fmona-* (* fsinh *)
	DC.W	fmona-* (* fintrz *)
	DC.W	fmona-* (* fsqrt *)
	DC.W	fmona-* (* flognp1 *)
	DC.W	fmona-* (* fetoxm1 *)
	DC.W	fmona-* (* ftanh *)
	DC.W	fmona-* (* fatan *)
	DC.W	fmona-* (* fasin *)
	DC.W	fmona-* (* fatanh *)
	DC.W	fmona-* (* fsin *)
	DC.W	fmona-* (* ftan *)
	DC.W	fmona-* (* fetox *)
	DC.W	fmona-* (* ftwotox *)
	DC.W	fmona-* (* ftentox *)
	DC.W	fmona-* (* flogn *)
	DC.W	fmona-* (* flog10 *)
	DC.W	fmona-* (* flog2 *)
	DC.W	fmona-* (* fabs *)
	DC.W	fmona-* (* fcosh *)
	DC.W	fmona-* (* fneg *)
	DC.W	fmona-* (* facos *)
	DC.W	fmona-* (* fcos *)
	DC.W	fmona-* (* fgetexp *)
	DC.W	fmona-* (* fgetman *)
	DC.W	fdyad-* (* fdiv *)
	DC.W	fdyad-* (* fmod *)
	DC.W	fdyad-* (* fadd *)
	DC.W	fdyad-* (* fmul *)
	DC.W	fdyad-* (* fsgldiv *)
	DC.W	fdyad-* (* frem *)
	DC.W	fdyad-* (* fscale *)
	DC.W	fdyad-* (* fsglmul *)
	DC.W	fdyad-* (* fsub *)
	DC.W	fsincos-* (* fsincos !!*)
	DC.W	fdyad-* (* fcmp *)
	DC.W	fmona-* (* ftst *)
	DC.W	fmovetoea-* (* fmove.? FPn,ea *)
	DC.W	fmovetofp-* (* fmove.? ea,FPn *)
	DC.W	fmovefpcr-* (* fmove.L FPcr,ea *)
	DC.W	fmovemfpcr-* (* fmovem.L FPcr..,ea *)
	DC.W	fmovem-* (* fmovem.X FPn *)

FCmdTab:
	DC.W	$FC00,$5C00
	DC.B	'MOVECR.','X'+128
	DC.W	$5000,0

	DC.W	$A07F,$0001
	DC.B	'INT',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0002
	DC.B	'SIN','H'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0003
	DC.B	'INTRZ',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0004
	DC.B	'SQR','T'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0006
	DC.B	'LOGNP','1'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0008
	DC.B	'ETOXM','1'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0009
	DC.B	'TAN','H'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$000A
	DC.B	'ATA','N'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$000C
	DC.B	'ASI','N'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$000D
	DC.B	'ATANH',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$000E
	DC.B	'SIN',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$000F
	DC.B	'TAN',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0010
	DC.B	'ETO','X'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0011
	DC.B	'TWOTO','X'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0012
	DC.B	'TENTO','X'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0014
	DC.B	'LOG','N'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0015
	DC.B	'LOG10',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0016
	DC.B	'LOG','2'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0018
	DC.B	'ABS',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0019
	DC.B	'COS','H'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$001A
	DC.B	'NEG',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$001C
	DC.B	'ACO','S'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$001D
	DC.B	'COS',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$001E
	DC.B	'GETEX','P'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$001F
	DC.B	'GETMA','N'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0020
	DC.B	'DIV',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0021
	DC.B	'MOD',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0022
	DC.B	'ADD',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0023
	DC.B	'MUL',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0024
	DC.B	'SGLDI','V'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0025
	DC.B	'REM',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0026
	DC.B	'SCALE',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0027
	DC.B	'SGLMU','L'+128
	DC.W	$0BFF,0

	DC.W	$A07F,$0028
	DC.B	'SUB',' '+128
	DC.W	$0BFF,0

	DC.W	$A078,$0030
	DC.B	'SINCO','S'+128 (* !! *)
	DC.W	$0BFF,0

	DC.W	$A07F,$0038
	DC.B	'CMP',' '+128
	DC.W	$0BFF,0

	DC.W	$A07F,$003A
	DC.B	'TST',' '+128
	DC.W	$0BFF,0

	DC.W	$E000,$6000 (* FMOVE.? FPn,ea *)
	DC.B	'MOV','E'+128
	DC.W	$0BF8,0

	DC.W	$A07F,$0000 (* FMOVE.? ea,FPn *)
	DC.B	'MOV','E'+128
	DC.W	$0BFF,0
(*
 * 16.8.92/bp die beiden naechsten Items vertauscht und bei
 *		FMOVEM.L $C3FF,$8000 statt $C3FF,$C000 eingetragen.
 *		Fehler in Motorola-Handbuch, beide sind identisch!
 *	Der FMOVE.L koennt nun entfallsen, ist mir aber zu gefaehrlich!
 *)
	DC.W	$C3FF,$8000 (* FMOVEM.L FPcr,ea *)
	DC.B	'MOVEM.L',' '+128
	DC.W	$1BFF,0

	DC.W	$C3FF,$8000 (* FMOVE FPcr,ea *)
	DC.B	'MOVE.','L'+128
	DC.W	$1BFF,0

	DC.W	$C700,$C000 (* FMOVEM.X *)
	DC.B	'MOVEM.X',' '+128
	DC.W	$1BFF,0

(* Tab-Ende *)
	DC.W	0,0

JmpTab:
	DC.W	T0-*		(* 0 *)
	DC.W	T1-*		(* 1 *)
	DC.W	T2-*		(* 2 *)
	DC.W	T3-*		(* 3 *)
	DC.W	T4-*		(* 4 *)
	DC.W	T0-*		(* 5 *)
	DC.W	T1-*		(* 6 *)
	DC.W	T3-*		(* 7 *)
	DC.W	T5-*		(* 8 *)
	DC.W	T6-*		(* 9 *)
	DC.W	QuellEA-*	(* 10 *)
	DC.W	QuellEA-*	(* 11 *)
	DC.W	T7-*		(* 12 *)
	DC.W	T7-*		(* 13 *)
	DC.W	T8-*		(* 14 *)
	DC.W	T9-*		(* 15 *)
	DC.W	T10-*		(* 16 *)
	DC.W	T9-*		(* 17 *)
	DC.W	T10-*		(* 18 *)
	DC.W	T9-*		(* 19 *)
	DC.W	T10-*		(* 20 *)
	DC.W	T9-*		(* 21 *)
	DC.W	T10-*		(* 22 *)
	DC.W	T11a-*		(* 23 *)
	DC.W	QuellEA-*	(* 24 *)
	DC.W	T11-*		(* 25 *)
	DC.W	T2-*		(* 26 *)
	DC.W	T3-*		(* 27 *)
	DC.W	T12-*		(* 28 *)
	DC.W	T8-*		(* 29 DBcc *)
	DC.W	T11a-*		(* 30 *)
	DC.W	T11a-*		(* 31 *)
	DC.W	T10-*		(* 32 *)
	DC.W	T3-*		(* 33 *)
	DC.W	T5-*		(* 34 *)
	DC.W	T6-*		(* 35 *)
	DC.W	T13-*		(* 36 *)
	DC.W	T14-*		(* 37 Ext.w/l *)
	DC.W	DUMMY-*		(* 38 *)
	DC.W	QuellEA-*	(* 39 *)
	DC.W	QuellEA-*	(* 40 *)
	DC.W	T30-*		(* 41 *)
	DC.W	T15-*		(* 42 *)
	DC.W	QuellEA-*	(* 43 *)
	DC.W	QuellEA-*	(* 44 *)
	DC.W	T7-*		(* 45 *)
	DC.W	T7-*		(* 46 *)
	DC.W	T16-*		(* 47 *)
	DC.W	T17-*		(* 48 *)
	DC.W	T18-*		(* 49 *)
	DC.W	T19-*		(* 50 *)
	DC.W	T20-*		(* 51 *)
	DC.W	T21-*		(* 52 MOVEA *)
	DC.W	T22-*		(* 53 MOVEm *)
	DC.W	T23-*		(* 54 *)
	DC.W	T24-*		(* 55 MOVEp *)
	DC.W	T25-*		(* 56 MOVEQ *)
	DC.W	T11a-*		(* 57 *)
	DC.W	T11a-*		(* 58 *)
	DC.W	QuellEA-*	(* 59 *)
	DC.W	QuellEA-*	(* 60 *)
	DC.W	QuellEA-*	(* 61 *)
	DC.W	DUMMY-*		(* 62 *)
	DC.W	QuellEA-*	(* 63 *)
	DC.W	T1-*		(* 64 *)
	DC.W	T3-*		(* 65 *)
	DC.W	T5-*		(* 66 *)
	DC.W	T6-*		(* 67 *)
	DC.W	QuellEA-*	(* 68 *)
	DC.W	DUMMY-*		(* 69 *)
	DC.W	QuellEA-*	(* 70 *)
	DC.W	QuellEA-*	(* 71 *)
	DC.W	T7-*		(* 72 *)
	DC.W	T7-*		(* 73 *)
	DC.W	QuellEA-*	(* 74 *)
	DC.W	QuellEA-*	(* 75 *)
	DC.W	T7-*		(* 76 *)
	DC.W	T7-*		(* 77 *)
	DC.W	DUMMY-*		(* 78 *)
	DC.W	DUMMY-*		(* 79 *)
	DC.W	DUMMY-*		(* 80 *)
	DC.W	T0-*		(* 81 *)
	DC.W	T26-*		(* 82 Scc *)
	DC.W	T27-*		(* 83 *)
	DC.W	T1-*		(* 84 *)
	DC.W	T2-*		(* 85 *)
	DC.W	T3-*		(* 86 *)
	DC.W	T4-*		(* 87 *)
	DC.W	T0-*		(* 88 *)
	DC.W	L00001C-*	(* 89 *)
	DC.W	QuellEA-*	(* 90 *)
	DC.W	T28-*		(* 91 *)
	DC.W	DUMMY-*		(* 92 *)
	DC.W	QuellEA-*	(* 93 *)
	DC.W	T29-*		(* 94 *)
	DC.W	rtd-*		(* 95 RTD #imm16 *)
	DC.W	TMoveCCR-*	(* 96 move ccr,ea *)

	DC.W	T14-*		(* 97 extb.l *)
	DC.W	T11b-*		(* 98 chk.l *)
	DC.W	Trapcc0-*	(* 99 *)
	DC.W	Trapcc1-*	(* 100 *)
	DC.W	Trapcc2-*	(* 101 *)
	DC.W	Mul32-*		(* 102 *)
	DC.W	Div32-*		(* 103 *)
	DC.W	Fdbcc-*		(* 104 *)
	DC.W	Ftrapcc-*	(* 105 *)
	DC.W	Ftrapcc16-*	(* 106 *)
	DC.W	Ftrapcc32-*	(* 107 *)
	DC.W	Fscc-*		(* 108 *)
	DC.W	Fbcc-*		(* 109 FBcc.W label *)
	DC.W	QuellEA-*	(* 110 Fsave *)
	DC.W	QuellEA-*	(* 111 Frestore *)
	DC.W	Fall-*		(* 112 *)

CmdTab:
	DC.W	$F1F0,$C100	(* 0 *)
	DC.B	'ABC','D'+128
	DC.W	$1880,$0880

	DC.W	$F000,$D000	(* 1 *)
	DC.B	'ADD',' '+128
	DC.W	$2FFF,$0BF8

	DC.W	$F0C0,$D0C0	(* 2 *)
	DC.B	'ADD','A'+128
	DC.W	$0FFF,$0400

	DC.W	$FF00,$0600	(* 3 *)
	DC.B	'ADD','I'+128
	DC.W	$6BF8,$0001

	DC.W	$F100,$5000	(* 4 *)
	DC.B	'ADD','Q'+128
	DC.W	$6FF8,$0001

	DC.W	$F130,$D100	(* 5 *)
	DC.B	'ADD','X'+128
	DC.W	$2880,$0880

	DC.W	$F000,$C000	(* 6 *)
	DC.B	'AND',' '+128
	DC.W	$2BFF,$03F8

	DC.W	$FF00,$0200	(* 7 *)
	DC.B	'AND','I'+128
	DC.W	$6BF8,$0001

	DC.W	$FFFF,$023C	(* 8 *)
	DC.B	'AND','I'+128
	DC.W	$5001,$0000

	DC.W	$FFFF,$027C	(* 9 *)
	DC.B	'AND','I'+128
	DC.W	$5001,$0000

	DC.W	$FFC0,$E1C0	(* 10 *)
	DC.B	'ASL',' '+128
	DC.W	$13F8,$0800

	DC.W	$FFC0,$E0C0	(* 11 *)
	DC.B	'ASR',' '+128
	DC.W	$13F8,$0800

	DC.W	$F118,$E100	(* 12 *)
	DC.B	'ASL',' '+128
	DC.W	$2801,$0800

	DC.W	$F118,$E000	(* 13 *)
	DC.B	'ASR',' '+128
	DC.W	$2801,$0800

	DC.W	$F000,$6000	(* 14 Bcc *)
	DC.B	'B',' '+128
	DC.W	$0000,$0000

	DC.W	$FFC0,$0840	(* 15 *)
	DC.B	'BCH','G'+128
	DC.W	$5BF8,$0001

	DC.W	$F1C0,$140	(* 16 *)
	DC.B	'BCH','G'+128
	DC.W	$1BF8,$0800

	DC.W	$FFC0,$0880	(* 17 *)
	DC.B	'BCL','R'+128
	DC.W	$5BF8,$0001

	DC.W	$F1C0,$0180	(* 18 *)
	DC.B	'BCL','R'+128
	DC.W	$1BF8,$0800

	DC.W	$FFC0,$08C0	(* 19 *)
	DC.B	'BSE','T'+128
	DC.W	$5BF8,$0001

	DC.W	$F1C0,$01C0	(* 20 *)
	DC.B	'BSE','T'+128
	DC.W	$1BF8,$0800

	DC.W	$FFC0,$0800	(* 21 *)
	DC.B	'BTS','T'+128
	DC.W	$5BFE,$0001

	DC.W	$F1C0,$0100	(* 22 *)
	DC.B	'BTS','T'+128
	DC.W	$1BFE,$0001

	DC.W	$F1C0,$4180	(* 23 *)
	DC.B	'CHK.W',' '+128
	DC.W	$1BFF,$0800

	DC.W	$FF00,$4200	(* 24 *)
	DC.B	'CLR',' '+128
	DC.W	$2BF8,$0000

	DC.W	$F100,$B000	(* 25 *)
	DC.B	'CMP',' '+128
	DC.W	$2FFF,$0800

	DC.W	$F0C0,$B0C0	(* 26 *)
	DC.B	'CMP','A'+128
	DC.W	$0FFF,$0400

	DC.W	$FF00,$0C00	(* 27 *)
	DC.B	'CMP','I'+128
	DC.W	$6BF8,$0001

	DC.W	$F138,$B108	(* 28 *)
	DC.B	'CMP','M'+128
	DC.W	$2100,$0100

	DC.W	$F0F8,$50C8	(* 29 *)
	DC.B	'D','B'+128
	DC.W	$0000,$0000

	DC.W	$F1C0,$81C0	(* 30 *)
	DC.B	'DIV','S'+128
	DC.W	$1BFF,$0800

	DC.W	$F1C0,$80C0	(* 31 *)
	DC.B	'DIV','U'+128
	DC.W	$1BFF,$0800

	DC.W	$F100,$B100	(* 32 KORRIGIERT *)
	DC.B	'EOR',' '+128
	DC.W	$2BF8,$0800

	DC.W	$FF00,$0A00	(* 33 *)
	DC.B	'EOR','I'+128
	DC.W	$6BF8,$0001

	DC.W	$FFFF,$0A3C	(* 34 *)
	DC.B	'EOR','I'+128
	DC.W	$5001,$0000

	DC.W	$FFFF,$0A7C	(* 35 *)
	DC.B	'EOR','I'+128
	DC.W	$5001,$0000

	DC.W	$F100,$C100	(* 36 *)
	DC.B	'EXG',' '+128
	DC.W	$1C00,$0C00

	DC.W	$FFB8,$4880	(* 37 *)
	DC.B	'EXT',' '+128
	DC.W	$0800,$0000

	DC.W	$FFFF,$4AFC	(* 38 *)
	DC.B	'ILLEGAL',' '+128
	DC.W	$0000,$0000

	DC.W	$FFC0,$4EC0	(* 39 *)
	DC.B	'JMP',' '+128
	DC.W	$127E,$0000

	DC.W	$FFC0,$4E80	(* 40 *)
	DC.B	'JSR',' '+128
	DC.W	$127E,$0000

	DC.W	$F1C0,$41C0	(* 41 *)
	DC.B	'LEA',' '+128
	DC.W	$127E,$0400

	DC.W	$FFF8,$4E50	(* 42 *)
	DC.B	'LIN','K'+128
	DC.W	$1400,$0000

	DC.W	$FFC0,$E3C0	(* 43 *)
	DC.B	'LSL',' '+128
	DC.W	$13F8,$0000

	DC.W	$FFC0,$E2C0	(* 44 *)
	DC.B	'LSR',' '+128
	DC.W	$13F8,$0000

	DC.W	$F118,$E108	(* 45 *)
	DC.B	'LSL',' '+128
	DC.W	$2801,$0800

	DC.W	$F118,$E008	(* 46 *)
	DC.B	'LSR',' '+128
	DC.W	$2801,$0800

	DC.W	$C000,$0000	(* 47 normal *)
	DC.B	'MOV','E'+128
	DC.W	$0BF8,$0FFF

	DC.W	$FFC0,$44C0	(* 48 MOVE TO CCR *)
	DC.B	'MOV','E'+128
	DC.W	$1BFF,$0000

	DC.W	$FFC0,$46C0	(* 49 MOVE TO SR *)
	DC.B	'MOV','E'+128
	DC.W	$1BFF,$0000

	DC.W	$FFC0,$40C0	(* 50 MOVE FROM SR *)
	DC.B	'MOV','E'+128
	DC.W	$1BF8,$0000

	DC.W	$FFF0,$4E60	(* 51 MOVE USP *)
	DC.B	'MOV','E'+128
	DC.W	$1400,$0400

	DC.W	$E1C0,$2040	(* 52 *)
	DC.B	'MOVEA',' '+128
	DC.W	$0FFF,$0400

	DC.W	$FF80,$4880	(* 53 *)
	DC.B	'MOVEM',' '+128
	DC.W	$02F8,$0C00

	DC.W	$FF80,$4C80	(* 54 *)
	DC.B	'MOVEM',' '+128
	DC.W	$037E,$0C00

	DC.W	$F138,$0108	(* 55 *)
	DC.B	'MOVEP',' '+128
	DC.W	$0040,$0040

	DC.W	$F100,$7000	(* 56 *)
	DC.B	'MOVEQ',' '+128
	DC.W	$5001,$0800

	DC.W	$F1C0,$C1C0	(* 57 *)
	DC.B	'MUL','S'+128
	DC.W	$1BFF,$0800

	DC.W	$F1C0,$C0C0	(* 58 *)
	DC.B	'MUL','U'+128
	DC.W	$1BFF,$0800

	DC.W	$FFC0,$4800	(* 59 *)
	DC.B	'NBC','D'+128
	DC.W	$1BF8,$0000

	DC.W	$FF00,$4400	(* 60 *)
	DC.B	'NEG',' '+128
	DC.W	$2BF8,$0000

	DC.W	$FF00,$4000	(* 61 *)
	DC.B	'NEG','X'+128
	DC.W	$2BF8,$0000

	DC.W	$FFFF,$4E71	(* 62 *)
	DC.B	'NOP',' '+128
	DC.W	$0000,$0000

	DC.W	$FF00,$4600	(* 63 *)
	DC.B	'NOT',' '+128
	DC.W	$2BF8,$0000

	DC.W	$F000,$8000	(* 64 *)
	DC.B	'O','R'+128
	DC.W	$2FFF,$0BF8

	DC.W	$FF00,$0000	(* 65 *)
	DC.B	'ORI',' '+128
	DC.W	$6BF8,$0001

	DC.W	$FFFF,$003C	(* 66 *)
	DC.B	'ORI',' '+128
	DC.W	$5000,$0000

	DC.W	$FFFF,$007C	(* 67 *)
	DC.B	'ORI',' '+128
	DC.W	$5000,$0000

	DC.W	$FFC0,$4840	(* 68 *)
	DC.B	'PEA',' '+128
	DC.W	$127E,$0000

	DC.W	$FFFF,$4E70	(* 69 *)
	DC.B	'RESET',' '+128
	DC.W	$0000,$0000

	DC.W	$FFC0,$E7C0	(* 70 *)
	DC.B	'ROL',' '+128
	DC.W	$13F8,$000

	DC.W	$FFC0,$E6C0	(* 71 *)
	DC.B	'ROR',' '+128
	DC.W	$13F8,$0000

	DC.W	$F118,$E118	(* 72 *)
	DC.B	'ROL',' '+128
	DC.W	$2801,$0800

	DC.W	$F118,$E018	(* 73 *)
	DC.B	'ROR',' '+128
	DC.W	$2801,$0800

	DC.W	$FFC0,$E5C0	(* 74 *)
	DC.B	'ROX','L'+128
	DC.W	$13F8,$0000

	DC.W	$FFC0,$E4C0	(* 75 *)
	DC.B	'ROX','R'+128
	DC.W	$13F8,$0000

	DC.W	$F118,$E110	(* 76 *)
	DC.B	'ROX','L'+128
	DC.W	$2801,$0800

	DC.W	$F118,$E010	(* 77 *)
	DC.B	'ROX','R'+128
	DC.W	$2801,$0800

	DC.W	$FFFF,$4E73	(* 78 *)
	DC.B	'RTE',' '+128
	DC.W	$0000,$0000

	DC.W	$FFFF,$4E77	(* 79 *)
	DC.B	'RTR',' '+128
	DC.W	$0000,$0000

	DC.W	$FFFF,$4E75	(* 80 *)
	DC.B	'RTS',' '+128
	DC.W	$0000,$0000

	DC.W	$F1F0,$8100	(* 81 *)
	DC.B	'SBC','D'+128
	DC.W	$1880,$0880

	DC.W	$F0C0,$50C0	(* 82 *)
	DC.B	'S',' '+128
	DC.W	$0BF8,$0000

	DC.W	$FFFF,$4E72	(* 83 *)
	DC.B	'STO','P'+128
	DC.W	$5000,$0000

	DC.W	$F000,$9000	(* 84 *)
	DC.B	'SUB',' '+128
	DC.W	$2FFF,$0BF8

	DC.W	$F0C0,$90C0	(* 85 *)
	DC.B	'SUB','A'+128
	DC.W	$0FFF,$0400

	DC.W	$FF00,$0400	(* 86 *)
	DC.B	'SUB','I'+128
	DC.W	$6BF8,$0001

	DC.W	$F100,$5100	(* 87 *)
	DC.B	'SUB','Q'+128
	DC.W	$6FF8,$0001

	DC.W	$F130,$9100	(* 88 *)
	DC.B	'SUB','X'+128
	DC.W	$2880,$0880

	DC.W	$FFF8,$4840	(* 89 *)
	DC.B	'SWA','P'+128
	DC.W	$1000,$0000

	DC.W	$FFC0,$4AC0	(* 90 *)
	DC.B	'TAS',' '+128
	DC.W	$1BF8,$0000

	DC.W	$FFF0,$4E40	(* 91 *)
	DC.B	'TRA','P'+128
	DC.W	$5000,$0000

	DC.W	$FFFF,$4E76	(* 92 *)
	DC.B	'TRAPV',' '+128
	DC.W	$0000,$0000

	DC.W	$FF00,$4A00	(* 93 *)
	DC.B	'TST',' '+128
	DC.W	$2BF8,$0000

	DC.W	$FFF8,$4E58	(* 94 *)
	DC.B	'UNL','K'+128
	DC.W	$1000,$0000

	DC.W	$FFFF,$4E74	(* 95 *)
	DC.B	'RTD',' '+128
	DC.W	$5000,$0000

	DC.W	$FFC0,$42C0	(* 96 *)	(* MOVE FROM CCR *)
	DC.B	'MOV','E'+128
	DC.W	$1BF8,$0000

	DC.W	$FFF8,$49C0	(* 97 *)
	DC.B	'EXT','B'+128
	DC.W	$0800,$0000

	DC.W	$F1C0,$4100	(* 98 *)
	DC.B	'CHK.L',' '+128
	DC.W	$1BFF,$0800

	DC.W	$F0FF,$50FC	(* 99 *) (* trapcc *)
	DC.B	'TRA','P'+128
	DC.W	$0000,$0000

	DC.W	$F0FF,$50FA	(* 100 *) (* trapcc #16 *)
	DC.B	'TRA','P'+128
	DC.W	$0000,$0000

	DC.W	$F0FF,$50FB	(* 101 *) (* trapcc #32 *)
	DC.B	'TRA','P'+128
	DC.W	$0000,$0000

	DC.W	$FFC0,$4C00	(* 102 *)
	DC.B	'MUL',' '+128
	DC.W	$0BFF,$0800

	DC.W	$FFC0,$4C40	(* 103 *)
	DC.B	'DIV',' '+128
	DC.W	$0BFF,$0800


	DC.W	$FFF8,$F248	(* 104 FDBcc *)
	DC.B	'FDB',' '+128
	DC.W	$0000,$0000

	DC.W	$FFFF,$F27C
	DC.B	'FTRAP',' '+128	(* 105 FTRAPcc *)
	DC.W	$0000,$0000

	DC.W	$FFFF,$F27A
	DC.B	'FTRAP',' '+128	(* 106 FTRAPcc #16 *)
	DC.W	$0000,$0000

	DC.W	$FFFF,$F27B
	DC.B	'FTRAP',' '+128	(* 107 FTRAPcc #32 *)
	DC.W	$0000,$0000

	DC.W	$FFC0,$F240	(* 108 FScc ea *)
	DC.B	'F','S'+128
	DC.W	$0BF8,$0000

	DC.W	$FFC0,$F280	(* 109 FBcc.W label *)
	DC.B	'F','B'+128
	DC.W	$0000,$0000

	DC.W	$FFC0,$F300	(* 110 FSAVE ea *)
	DC.B	'FSAVE',' '+128
	DC.W	$12F8,$0000

	DC.W	$FFC0,$F340	(* 111 FRESTORE ea *)
	DC.B	'FRESTOR','E'+128
	DC.W	$137E,$0000

	DC.W	$FFC0,$F200    (* 112 alles fr Fxxxx *)
	DC.B	'F',' '+128
	DC.W	$0FFF,$0000

(* Erstes Byte nach text: Bit 4: Tab24 Bit5:CalcArgLen Bit6:PutImm *)
	DC.W	$0000,$0000	(* TAB-ENDE *)
	DC.W	0,0
	END);
END Disass;

(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(RTS END);
CLOSE
  ASSEMBLE(RTS END);
END DisAss.mod
