IMPLEMENTATION MODULE Detach;

(*$ NilChk:=FALSE LargeVars:=FALSE StackParms:=FALSE
    RangeChk:=FALSE OverflowChk:=FALSE
 *)

(*
 * 8.8.92/bp
 *
 *)

FROM SYSTEM	IMPORT ADR,ADDRESS,BPTR,CAST,TAG;
IMPORT A:Arts, DD:DosD, DL:DosL, EL:ExecL;

(*$ DEFINE Debug:=FALSE *)

VAR
  (*$ LongAlign:=TRUE *)
  (* resSeg # NIL: ich wurde resident gestartet. Probleme, Probleme... *)
  resSeg:DD.ResidentSegmentAPtr;


PROCEDURE Detach(name:ADDRESS;
		 pri:LONGINT;
		 stackSize:LONGINT;
		 input,
		 output:DD.FileHandlePtr
		 );
VAR
  mySeg:BPTR;
  tagBuff:ARRAY[1..23] OF LONGINT;
  freeSeg,
  closeOutput:BOOLEAN;
BEGIN
(*
 * Test, ob reentrant, sonst geht es nicht, weil Variablen schon
 * verndert wurden!
 * Ich wei nicht, wie ich das testen sollte...
 *)

  IF NOT A.wbStarted THEN (* Shell oder Background *)
    A.Assert(A.kickVersion>=37,ADR("Ich brauche Kick 37!"));
    A.Assert((input#NIL)&(output#NIL),ADR("in oder out ist NIL!"));

    (* input, output identisch? *)
    closeOutput:=input#output;

    (* eigene SegList finden *)
    mySeg:=CAST(DD.ProcessPtr,A.thisTask)^.cli^.module;

    (* Bin ich resident gestartet worden? *)
    EL.Forbid;
    resSeg:=DL.FindSegment(A.programName,NIL,FALSE);
    IF resSeg#NIL THEN
      IF resSeg^.segment#mySeg THEN (* Ich bin NICHT resident gestartet worden! *)
        resSeg:=NIL;
      END;
    END;
    EL.Permit;

    (* Hintergrundproze? Dann zurckkehren *)
    IF CAST(DD.ProcessPtr,A.thisTask)^.cli^.background # 0 THEN
     (*
       Wenn ich resident gestartet wurde, erniedrigt die Shell den
       usecount trotzdem, auch wenn ich module=NIL setze!
       Also erhht und erniedrigt der Hintergrundproze den
       usecount selbstndig. Das ist nicht ganz sauber, aber ich
       wei ja nicht, ob ich durch RUN oder durch Detach erzeugt
       wurde! Und den Boden lasse ich mir nicht wegziehen!
      *)
      DL.Close(input);
      IF closeOutput THEN DL.Close(output) END;
      (* residentcount erhhen. NICHT GANZ SAUBER!! *)
      IF resSeg#NIL THEN INC(resSeg^.usecount) END;
      (* usecount wird bei CLOSE wieder erniedrigt. *)
      (*$ IF Debug *)
        A.BreakPoint(ADR("backgr"));
      (*$ ENDIF *)

    ELSE (* Vordergrundproze, also Proze starten, mich beenden *)
      freeSeg:=resSeg=NIL; (* nicht resident, also free *)
      (* resSeg muss zu NIL werden wegen CLOSE! *)
      resSeg:=NIL;
      (*$ IF Debug *)
        A.BreakPoint(ADR("starte gleich neuen"));
      (*$ ENDIF *)

      (* Prozess starten *)
      IF DL.CreateNewProc(TAG(tagBuff,
	  DD.npSeglist,		CAST(ADDRESS,mySeg),
	  DD.npFreeSeglist,	freeSeg,
	  DD.npInput,		CAST(ADDRESS,input),
	  DD.npOutput,		CAST(ADDRESS,output),
	  DD.npCloseOutput,	closeOutput,
	  DD.npStackSize,	stackSize,
	  DD.npPriority,	pri,
	  DD.npCli,		TRUE, (* muss CLI sein wegen der Argumente! *)
	  DD.npName,		ADR("Detached Process"),
	  DD.npCommandName,	name,
	  DD.npArguments,	A.dosCmdBuf,
	  0)
	 ) # NIL THEN (* Mich selbst loeschen! *)
        CAST(DD.ProcessPtr,A.thisTask)^.cli^.module:=NIL;
        A.Terminate; (* kommt natuerlich nicht zurueck! *)
      END;
    END; (* If background *)
  END; (* if NOT wbStarted *)
END Detach;

PROCEDURE DetachNorm(inname,outname:ARRAY OF CHAR);
(*$ CopyDyn:=FALSE *)
VAR
  in,out:DD.FileHandlePtr;
BEGIN
  (* bei wb oder background brauchen wir die Files gar nicht erst zu oeffnen *)
  IF A.wbStarted THEN
    (* gar nichts tun *)
  ELSIF CAST(DD.ProcessPtr,A.thisTask)^.cli^.background # 0 THEN
    (* Dummy-Aufruf. Wegen usecount unbedingt ntig. *)
    in:=DL.Open(ADR("*"),DD.oldFile);
    Detach(A.programName,0,0,in,in);
  ELSE
    in:=DL.Open(ADR(inname),DD.oldFile);
    IF outname[0]#0C THEN
      out:=DL.Open(ADR(outname),DD.newFile);
    ELSE
      out:=in;
    END;
    Detach(
      A.programName,
      CAST(DD.ProcessPtr,A.thisTask)^.task.node.pri,
      CAST(DD.ProcessPtr,A.thisTask)^.cli^.defaultStack * 4,
      in,
      out);
  END;
END DetachNorm;

BEGIN
  resSeg:=NIL;
CLOSE
  IF resSeg#NIL THEN
    DEC(resSeg^.usecount);
    resSeg:=NIL;
  END;
END Detach.mod
