IMPLEMENTATION MODULE DecBase;
(* 05.08.88/cn; 29.10.89/red; 03.11.89/cn; 13.11.89/ms,red 20.6.90/bp
   14.11.90/bp
 *)
(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)

FROM SYSTEM	IMPORT	ADR, BYTE, CAST,SETREG,ADDRESS;
FROM Arts	IMPORT	returnVal,BreakPoint;
FROM ExecL	IMPORT	CopyMem;
FROM ASCII	IMPORT	nul,lf;
FROM DateConversions IMPORT DateInfo,DateToStr,FromDos;
FROM DosD	IMPORT	Date;
FROM M2Amiga	IMPORT	LoadFile,FreeFile,LFResult;
FROM M2File	IMPORT	pathFileName,FileType,GetInputFile,ReadPathTable;
FROM String	IMPORT	noOccur,FirstPos,Copy;
FROM Terminal	IMPORT	waitCloseGadget,Write, WriteLn, Read, WriteString;
FROM ArgHandler IMPORT	fNameLen,interActive,InitHandler,FetchName,
			fName,SetReply;
FROM ReplyVals	IMPORT	rcIllOpt,rcMainNotFound;
FROM Break	IMPORT	TestBreak;

CONST
 errMsg=" --- nicht gefunden\n";
 endMsg=" --- fertig\n";
 monate="Jan|Feb|Mr|Apr|Mai|Jun|Jul|Aug|Sep|Okt|Nov|Dez";

VAR (*$ LongAlign:=TRUE *)
 Buffer:ADDRESS;
 BuffLen:LONGINT;
 Pointer:ADDRESS;

PROCEDURE Get(VAR v: ARRAY OF BYTE):BOOLEAN;
BEGIN
 CopyMem(Pointer,ADR(v),HIGH(v)+1);
 INC(Pointer,HIGH(v)+1);
 RETURN CAST(LONGINT,Pointer)>(CAST(LONGINT,Buffer)+BuffLen);
END Get;

PROCEDURE GetPtr():ADDRESS;
BEGIN
  RETURN Pointer;
END GetPtr;

PROCEDURE SetPtr(a:ADDRESS);
BEGIN
  Pointer:=a;
END SetPtr;

VAR
 line: ARRAY [0..999] OF CHAR;
 pos: INTEGER;

PROCEDURE OutC(c:CHAR);
VAR ch:CHAR;
BEGIN
  IF (c>=CHAR(128+32)) OR (c>=" ")&(c<=CHAR(127)) THEN
    line[pos]:=c; INC(pos);
  ELSE
    line[pos]:="\\"; INC(pos);
    CASE c OF
    | "\n": ch:='n';
    | "\o": ch:='o';
    | "\[": ch:='[';
    | "\e": ch:='e';
    | "\t": ch:='t';
    | ELSE
       line[pos]:="x"; INC(pos);
       ch:=CHAR(ORD(c) DIV 16 +30H);
       IF ch>'9' THEN INC(ch,7) END;
       line[pos]:=ch; INC(pos);
       ch:=CHAR(ORD(c) MOD 16 +30H);
       IF ch>'9' THEN INC(ch,7) END;
    END;
    line[pos]:=ch; INC(pos);
  END;
END OutC;

PROCEDURE OutChar(c:CHAR);
TYPE
 UByte=[0..255];
VAR
 quote:CHAR;
BEGIN
 IF (c<" ") OR (c>"~") THEN
  OutC(CHAR(UByte(c) DIV 64+UByte("0")));
  OutC(CHAR(UByte(c) DIV 8 MOD 8+UByte("0")));
  OutC(CHAR(UByte(c) MOD 8+UByte("0")));
  OutC("C");
 ELSE
  IF c='"' THEN quote:="'"; ELSE quote:='"'; END;
  OutC(quote); OutC(c); OutC(quote);
 END;
END OutChar;

(*$ CopyDyn:=FALSE *)
PROCEDURE OutS(s:ARRAY OF CHAR);
VAR
 j: INTEGER;
 c: CHAR;
BEGIN
 FOR j:=0 TO HIGH(s) DO
  c:=s[j]; IF c=nul THEN RETURN END;
  line[pos]:=c; INC(pos)
 END;
 TestBreak;
END OutS;

VAR
 Hex: ARRAY [0..15] OF CHAR;

(*$ CopyDyn:=FALSE *)
PROCEDURE OutHex(w: ARRAY OF BYTE);
TYPE
 UByte=[0..255];
VAR
 i: INTEGER;
BEGIN
 FOR i:=0 TO HIGH(w) DO
  line[pos]:=Hex[CAST(UByte,w[i]) DIV 16];
  line[pos+1]:=Hex[CAST(UByte,w[i]) MOD 16]; INC(pos,2)
 END
END OutHex;

PROCEDURE Out2(i:INTEGER; fill:CHAR);
BEGIN
 IF i<10 THEN OutC(fill); END;
 OutInt(i);
END Out2;

PROCEDURE OutKey(k:ModKeys);
VAR
 i,d,m,y:INTEGER;
 dd:Date;
 di:DateInfo;
 s:ARRAY [0..79] OF CHAR;
BEGIN
 FOR i:=0 TO 2 DO OutHex(k[i]); OutC(' '); END;
 dd.days:=k[0]; dd.minute:=k[1]; dd.tick:=k[2];
 FromDos(dd,di);
 DateToStr(di,"%d-%t-%Y %H:%M:%S.%2",monate,s);
 OutS(s);
END OutKey;

PROCEDURE OutCard(c:LONGCARD);
VAR
 f: LONGCARD;
 c2: RECORD
  CASE :CARDINAL OF
  | 0: l: LONGCARD
  | 1: hi,lo: CARDINAL
  END
 END;
BEGIN
 c2.l:=c DIV 10; f:=1; WHILE f<=c2.l DO f:=f*10 END;
 REPEAT
  c2.l:=c DIV f; line[pos]:=CHR(c2.lo+48); INC(pos); c:=c-c2.l*f;
  f:=f DIV 10
 UNTIL f=0
END OutCard;

PROCEDURE OutInt(i:LONGINT);
BEGIN
 IF i=(-80000000H) THEN OutS("-2147483648");
 ELSE
  IF i<0 THEN OutC("-") END;
  OutCard(ABS(i));
 END;
END OutInt;

PROCEDURE OutLn;
VAR
 l: LONGINT;
BEGIN
 line[pos]:=lf;
 line[pos+1]:=nul; WriteString(line);
 pos:=0;
 TestBreak;
END OutLn;

PROCEDURE OutCondLn(last:INTEGER):BOOLEAN;
VAR
 nl:BOOLEAN;
 l: LONGINT;
BEGIN
 nl:=pos>=last;
 IF nl THEN
  line[pos]:=lf;
  line[pos+1]:=nul; WriteString(line);
  pos:=0;
  TestBreak;
 END;
 RETURN nl;
END OutCondLn;

PROCEDURE OutLR(r:LONGREAL);
CONST
 expPlaces=3; expMax=1000; (* 10^expPlaces *)
 precision=8;

VAR
 e,d,i,q: INTEGER;
 round: LONGREAL;

 PROCEDURE put(c: CHAR); BEGIN line[pos]:=c; INC(pos) END put;

 BEGIN
  IF r<0.0 THEN line[pos]:='-'; INC(pos); r:=-r; END;
  e:=0;
  WHILE r>=10.0 DO r:=r/10.0; INC(e) END;            (* r<10, Zahl ist r*10^d *)
  IF r#0.0 THEN WHILE r<1.0 DO r:=r*10.0; DEC(e) END END;
  round:=0.5; FOR i:=1 TO precision DO round:=round/10.0 END;
  r:=r+round;
  IF r>=10.0 THEN INC(e); r:=r/10.0; END;
  d:=0;
  LOOP
   q:=TRUNC(r); line[pos]:=CHR(48+q); INC(pos); r:=(r-LONGREAL(q))*10.0;
   IF d=-precision THEN EXIT END;
   IF d=0 THEN line[pos]:="."; INC(pos); END;
   DEC(d)
  END;
  put('E'); IF e<0 THEN e:=-e; line[pos]:="-"; INC(pos); END;
  d:=expMax;          (* because 'd' and 'q' are nolonger used, let's us it! *)
  FOR q:=1 TO expPlaces DO
   d:=d DIV 10; line[pos]:=CHR(48+e DIV d); INC(pos); e:=e MOD d;
  END
END OutLR;

(*$ CopyDyn:=FALSE *)
PROCEDURE Error(msg: ARRAY OF CHAR; rVal:LONGINT);
BEGIN
 SetReply(rVal);
 OutLn; WriteString(msg);
END Error;


VAR use:ARRAY[0..99] OF CHAR;

(*$ CopyDyn:=FALSE *)
PROCEDURE Options(o:ARRAY OF CHAR; len:INTEGER):BOOLEAN;
BEGIN
  SetReply(rcIllOpt);
  WriteString(use);
  RETURN FALSE
END Options;

PROCEDURE  WriteInFile(VAR fileName: ARRAY OF CHAR);
BEGIN
 WriteString(" - "); WriteString(fileName); WriteLn;
END WriteInFile;

(*$ CopyDyn:=FALSE *)
PROCEDURE Do(Decode:DecProc; titleString, usage:ARRAY OF CHAR;
 fileType:FileType; msg,envName,locName:ADDRESS);
VAR
  fileName:ARRAY [0..107] OF CHAR;
  dejaVue:BOOLEAN;
BEGIN
  dejaVue:=FALSE;
  Copy(use,usage);
  WriteString(titleString);
  InitHandler(Options,msg,envName,locName);

  waitCloseGadget:=TRUE;

  IF ~FetchName() THEN RETURN END; (* bei Aufruffehler gleich raus *)
  IF fNameLen=0 THEN interActive:=TRUE END;
  ReadPathTable(pathFileName);
  (* Nun erstes Arg holen! *)
  LOOP
    IF dejaVue OR (fNameLen=0) THEN
      REPEAT
      UNTIL FetchName(); (* bis Leerstring oder guter *)
    END;
    dejaVue:=TRUE;
    IF fNameLen=0 THEN EXIT END;

    IF (fileType=refFile) & (fNameLen>=4)
      & (fName[fNameLen-4]='.') & (CAP(fName[fNameLen-3])='S') THEN
      GetInputFile(fileName,symFile,fName);
    ELSE
      GetInputFile(fileName,fileType,fName);
    END;


    IF LoadFile(fileName,Buffer,BuffLen)=lfOk THEN
      Pointer:=Buffer;
      WriteInFile(fileName);
      Decode();
      FreeFile(Buffer,BuffLen);
    ELSE
      WriteString(fileName); WriteString(errMsg);
      SetReply(rcMainNotFound);
    END;

    IF returnVal>0 THEN
      interActive:=TRUE;
    END;
  END; (* loop *)

  IF interActive THEN
    WriteString(endMsg);
  END;
  waitCloseGadget:=~interActive;
END Do;

BEGIN
 Hex:="0123456789ABCDEF";
END DecBase.
