IMPLEMENTATION MODULE CommoditiesSupport;
(*$ NilChk:=FALSE LargeVars:=FALSE LongAlign:=FALSE StackParms:=FALSE Volatile:=FALSE StackChk:=FALSE *)

FROM SYSTEM	IMPORT	ADR,ADDRESS,CAST;
FROM InputEvent	IMPORT	InputEvent,InputEventPtr,null;
FROM KeyMapD	IMPORT	KeyMapPtr;
FROM WorkbenchD	IMPORT	DiskObjectPtr;
FROM Heap	IMPORT	Allocate;
IMPORT
  CD: CommoditiesD,
  CL: CommoditiesL,
  IL: IconL,
  ED: ExecD,
  EL: ExecL,
  A:  Arts,
  Ar: Arguments,
  R;

TYPE
  CharPtr=POINTER TO CHAR;

VAR
  (*$ LongAlign:=TRUE *)
  argArr:POINTER TO ARRAY [0..1000] OF StrPtr;
  do:DiskObjectPtr;
  argArrSize:LONGINT;

(* CxObjPtr, CxMsgPtr: sind Opaque! *)

(*************************
 * object creation macros
 *************************)

PROCEDURE CxFilter(d:StrPtr):CD.CxObjPtr;
BEGIN
  RETURN CL.CreateCxObj(CD.cxFilter,d, 0);
END CxFilter;

PROCEDURE CxTypeFilter(type:LONGINT):CD.CxObjPtr;
BEGIN
  RETURN CL.CreateCxObj(CD.cxTypefilter,type, 0);
END CxTypeFilter;

PROCEDURE CxSender(port:ED.MsgPortPtr; id:LONGINT):CD.CxObjPtr;
BEGIN
  RETURN CL.CreateCxObj(CD.cxSend,port,id);
END CxSender;

PROCEDURE CxSignal(task:ED.TaskPtr; sigNum:LONGINT):CD.CxObjPtr;
BEGIN
  RETURN CL.CreateCxObj(CD.cxSignal,task,sigNum);
END CxSignal;

PROCEDURE CxTranslate(ie:InputEventPtr):CD.CxObjPtr;
BEGIN
  RETURN CL.CreateCxObj(CD.cxTranslate,ie,0);
END CxTranslate;

PROCEDURE CxDebug(id:LONGINT):CD.CxObjPtr;
BEGIN
  RETURN CL.CreateCxObj(CD.cxDebug,id, 0);
END CxDebug;

PROCEDURE CxCustom(action:CustomProc; id:LONGINT):CD.CxObjPtr;
BEGIN
  RETURN CL.CreateCxObj(CD.cxCustom,CAST(ADDRESS,action),id);
END CxCustom;

(* matches nothing   *)
PROCEDURE NullIx(VAR i:CD.IX):BOOLEAN;
BEGIN
  RETURN i.class=null;
END NullIx;

(* Procedures from cx_lib *)
PROCEDURE ArgArrayDone();
BEGIN
  IF argArrSize#0 THEN
    argArrSize:=0;
    argArr:=NIL;
  END;
  IF do#NIL THEN
    IL.FreeDiskObject(do);
    do:=NIL
  END;
END ArgArrayDone;

PROCEDURE ArgArrayInit;
VAR
  i,len,args:INTEGER;
  str:ARRAY[0..127] OF CHAR;
BEGIN
  IF A.wbStarted THEN (* do holen *)
    do:=IL.GetDiskObject(A.programName);
    IF do#NIL THEN
      argArr:=do^.toolTypes;
    ELSE
      argArr:=NIL;
    END;
  ELSE
    args:=Ar.NumArgs();
    IF args>0 THEN
      argArrSize:=(args+1)*4;
      Allocate(argArr,argArrSize);
      IF argArr#NIL THEN
        FOR i:=0 TO args-1 DO
          Ar.GetArg(i+1,str,len);
          Allocate(argArr^[i],len+1);
          IF argArr^[i]#NIL THEN
            EL.CopyMem(ADR(str),argArr^[i],len);
          END;
        END;
      END;
    END;
  END;
END ArgArrayInit;

PROCEDURE ArgString(str:StrPtr; defaultStr:StrPtr):StrPtr;
VAR
  fnd:StrPtr;
BEGIN
  IF argArr#NIL THEN
    fnd:=IL.FindToolType(argArr,str);
  ELSE
    fnd:=NIL
  END;
  IF fnd=NIL THEN
    RETURN defaultStr
  ELSE
    RETURN fnd
  END;
END ArgString;

(* s surely # NIL! *)
PROCEDURE atoi(s{R.A0}:CharPtr):LONGINT;
VAR
  val:LONGINT;
  ch:CHAR;
  neg:BOOLEAN;
BEGIN
  val:=0;
  IF s^='-' THEN
    INC(s);
    neg:=TRUE;
  ELSE
    neg:=FALSE
  END;
  WHILE (s^>="0")&(s^<="9") DO
    val:=val*10+ORD(s^)-30H;
    INC(s);
  END;
  IF neg THEN
    RETURN -val
  ELSE
    RETURN val;
  END;
END atoi;

PROCEDURE ArgInt(str:StrPtr; defaultVal:LONGINT):LONGINT;
VAR
  fnd:StrPtr;
BEGIN
  IF argArr#NIL THEN
    fnd:=IL.FindToolType(argArr,str);
  ELSE
    fnd:=NIL
  END;
  IF fnd=NIL THEN
    RETURN defaultVal
  ELSE
    RETURN atoi(fnd)
  END;
END ArgInt;

PROCEDURE FreeIEvents(ie:InputEventPtr);
VAR i{R.A3},next{R.A2}:InputEventPtr;
BEGIN
  i:=ie;
  WHILE i#NIL DO
    next:=i^.nextEvent;
    EL.FreeMem(i,SIZE(i^));
    i:=next;
  END;
END FreeIEvents;

PROCEDURE HotKey(descr:StrPtr; port:ED.MsgPortPtr; ID:LONGINT):CD.CxObjPtr;
VAR
  filter:CD.CxObjPtr;
BEGIN
  filter:=CxFilter(descr);
  IF filter#NIL THEN
    CL.AttachCxObj(filter,CxSender(port,ID));
    CL.AttachCxObj(filter,CxTranslate(NIL));
    IF CL.CxObjError(filter)#CD.CoErrorSet{} THEN
      CL.DeleteCxObjAll(filter);
      CAST(ADDRESS,filter):=NIL
    END;
  END;
  RETURN filter;
END HotKey;

PROCEDURE UserFilter(str:StrPtr; defaultFilter:StrPtr):CD.CxObjPtr;
VAR
  fnd:StrPtr;
BEGIN
  IF argArr#NIL THEN
    fnd:=IL.FindToolType(argArr,str);
  ELSE
    fnd:=NIL
  END;
  IF fnd=NIL THEN
    fnd:=defaultFilter;
  END;
  RETURN CxFilter(fnd);
END UserFilter;

PROCEDURE InvertString(str:StrPtr; km:KeyMapPtr):InputEventPtr;

  PROCEDURE doesc(ch{0}:CHAR):CHAR;
  BEGIN
    IF (ch='"')OR(ch="'")OR(ch="<")OR(ch="\\") THEN RETURN ch
    ELSIF ch="0" THEN RETURN 0C
    ELSIF (ch="n")OR(ch="r") THEN RETURN "\r"
    ELSIF ch="t" THEN RETURN "\t"
    ELSE
      RETURN CHAR(0FFH);
    END;
  END doesc;

  PROCEDURE doangle(VAR ie:InputEvent; VAR str:CharPtr):BOOLEAN;
  VAR
    ix:CD.IX;
    s:CharPtr;
    err:LONGINT;
    patched:BOOLEAN;
  BEGIN
    s:=str;
    patched:=FALSE;
    LOOP
      IF s^=0C THEN
        EXIT
      ELSIF s^=">" THEN
        s^:=0C;
        patched:=TRUE;
        EXIT
      END;
      INC(s);
    END;
    err:=CL.ParseIX(str,ix);
    IF patched THEN
      s^:=">";
    ELSE
      DEC(s); (* VOR die 0C! *)
    END;
    str:=s;
    IF err#0 THEN
      RETURN FALSE
    ELSE
      ie.class:=ix.class;
      ie.code:=ix.code;
      ie.qualifier:=ix.qualifier;
      RETURN TRUE;
    END;
  END doangle;

VAR
  last{R.A2},ie:InputEventPtr;
  ch{R.D6}:CHAR;
  err:BOOLEAN;
BEGIN
  err:=FALSE;
  last:=NIL;
  IF (CAST(CharPtr,str)=NIL)OR(CAST(CharPtr,str)^=0C) THEN
    RETURN NIL
  END;
  LOOP
    ie:=EL.AllocMem(SIZE(ie^),ED.MemReqSet{ED.public,ED.memClear});
    IF ie=NIL THEN
      err:=TRUE;
      EXIT
    END;
    ie^.nextEvent:=last;
    last:=ie;
    ch:=CAST(CharPtr,str)^;
    IF ch="<" THEN
      INC(str);
      IF ~doangle(ie^,CAST(CharPtr,str)) THEN
        err:=TRUE;
        EXIT;
      END;
    ELSE
      IF ch="\\" THEN
        INC(str);
        ch:=doesc(CAST(CharPtr,str)^);
        IF ch=CHAR(0FFH) THEN
          err:=TRUE;
          EXIT;
        END;
      END;
      IF ~CL.InvertKeyMap(LONGCARD(ch),ie^,km) THEN
        err:=TRUE;
        EXIT;
      END;
    END;
    INC(str);
    IF CAST(CharPtr,str)^=0C THEN EXIT END;
  END;
  IF err THEN
    FreeIEvents(ie);
    RETURN NIL
  ELSE
    RETURN last;
  END;
END InvertString;

BEGIN
  ArgArrayInit
CLOSE
  ArgArrayDone;
END CommoditiesSupport.mod
