#include <exec/types.h>
#include <libraries/dosextens.h>

#define toAPTR(b) ((b)<<2)
#define toBPTR(a) ((a)>>2)

struct DeviceList *list;

OpenVolList()
{
	extern struct DosLibrary *DOSBase;
	struct RootNode *root;
	struct DosInfo *info;

	root = DOSBase -> dl_Root;
	info = toAPTR(root->rn_Info);
	list = toAPTR(info->di_DevInfo);
}

ReadVolList(name)
char name[32];
{
	struct DeviceList *next;

	while(list) {
		next = toAPTR(list->dl_Next);
		if(    (list->dl_Type == DLT_VOLUME)
		    || (list->dl_Type == DLT_DIRECTORY)) {
			char *ptr;
			int count;
			ptr = toAPTR((BPTR)list->dl_Name);
			count = *ptr++;
			if(count > 30)
				count = 30;
			strncpy(name, ptr, count);
			name[count++] = ':';
			name[count] = 0;
			list = next;
			return 1;
		}
		list = next;
	}
	return 0;
}

CloseVolList()
{
}
