#include <devices/keymap.h>

#define KC_DEFAULT 0xFF
#define noEntry 0x00000000

static UBYTE HiKeyMapTypes[40] = {
   KC_DEFAULT,				/* Space */
   KCF_STRING | KCF_SHIFT | KCF_ALT,	/* Backspace */
   KC_DEFAULT,				/* Tab */
   KC_DEFAULT,				/* ENTER (numeric) */
   KCF_CONTROL,				/* Return */
   KCF_ALT,				/* Escape */
   KCF_STRING | KCF_SHIFT | KCF_ALT,	/* DEL */
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,				/* Numeric - */
   KC_DEFAULT,
   KCF_STRING | KCF_SHIFT | KCF_ALT,	/* Cursor Up */
   KCF_STRING | KCF_SHIFT | KCF_ALT,	/* Cursor Down */
   KCF_STRING | KCF_SHIFT | KCF_ALT,	/* Cursor Right */
   KCF_STRING | KCF_SHIFT | KCF_ALT,	/* Cursor Left */
   KCF_STRING | KCF_SHIFT,		/* F1 */
   KCF_STRING | KCF_SHIFT,		/* F2 */
   KCF_STRING | KCF_SHIFT,		/* F3 */
   KCF_STRING | KCF_SHIFT,		/* F4 */
   KCF_STRING | KCF_SHIFT,		/* F5 */
   KCF_STRING | KCF_SHIFT,		/* F6 */
   KCF_STRING | KCF_SHIFT,		/* F7 */
   KCF_STRING | KCF_SHIFT,		/* F8 */
   KCF_STRING | KCF_SHIFT,		/* F9 */
   KCF_STRING | KCF_SHIFT,		/* F10 */
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KCF_STRING,				/* HELP */
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT,
   KC_DEFAULT
};

static UBYTE *HiKeyMap[40] = {
 (UBYTE * ) noEntry,		/* Space */
 (UBYTE * ) "\001\010\002\011\002\013\002\015\010\030\013\033\177\030\013",/* Backspace */
 (UBYTE * ) noEntry,		/* Tab */
 (UBYTE * ) noEntry,		/* ENTER (numeric) */
 (UBYTE * ) 0x00000A0D,		/* Return */
 (UBYTE * ) 0x00009B1B,		/* Escape */
 (UBYTE * ) "\001\010\001\011\002\012\001\014\004\013\033D\013", /* DEL */
 (UBYTE * ) noEntry,
 (UBYTE * ) noEntry,
 (UBYTE * ) noEntry,
 (UBYTE * ) noEntry,		/* Numeric - */
 (UBYTE * ) noEntry,
 (UBYTE * ) "\001\010\002\011\002\013\002\015\020\033<\033V\033<",  /* CU */
 (UBYTE * ) "\001\010\002\011\001\013\002\014\016\033>\026\033B>",   /* CD */
 (UBYTE * ) "\001\010\001\011\002\012\002\014\006\005\033F\033F",   /* CR */
 (UBYTE * ) "\001\010\001\011\002\012\002\014\002\001\033B\033B",   /* CL */
 (UBYTE * ) "\002\004\002\006\030\022\030\023",		/* F1  ^x^r ^x^s */
 (UBYTE * ) "\002\004\002\006\030\015\030M",		/* F2  ^x^m ^xm  */
 (UBYTE * ) "\001\004\002\005\023\033%",		/* F3  ^s   ^[%  */
 (UBYTE * ) "\002\004\002\006\030(\030)",		/* F4  ^x(  ^x)  */
 (UBYTE * ) "\002\004\001\006\030E\007",		/* F5  ^xe  ^g   */
 (UBYTE * ) "\002\004\002\006\033M\030=",		/* F6  ^[m  ^x=  */
 (UBYTE * ) "\002\004\002\006\030\062\030\060",		/* F7  ^x2  ^x0  */
 (UBYTE * ) "\002\004\002\006\030\032\030Z",		/* F8  ^x^z ^xz  */
 (UBYTE * ) "\002\004\002\006\030\016\030\020",		/* F9  ^x^n ^x^p */
 (UBYTE * ) "\002\004\001\006\030\004\017",		/* F10 ^x^d ^o   */
 (UBYTE * ) noEntry,
 (UBYTE * ) noEntry,
 (UBYTE * ) noEntry,
 (UBYTE * ) noEntry,
 (UBYTE * ) noEntry,
/* (UBYTE * ) 0x00000015,	    HELP */
 (UBYTE * ) "\002\002\030H",	/*  HELP */
 (UBYTE * ) noEntry,		/* lSHFT */
 (UBYTE * ) noEntry,		/* rSHFT */
 (UBYTE * ) noEntry,		/* CAPS */
 (UBYTE * ) noEntry,		/* CTRL */
 (UBYTE * ) noEntry,		/* lALT */
 (UBYTE * ) noEntry,		/* rALT */
 (UBYTE * ) noEntry,		/* lAMIGA */
 (UBYTE * ) noEntry		/* rAMIGA */
};
static UBYTE HiCapsable[8] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
static UBYTE HiRepeatable[8] = {
  0x47, 0xF4, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00
};
