#include <exec/types.h>
#include <intuition/intuition.h>
#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/exec_pragmas.h>
#include <clib/intuition_pragmas.h>
#include <string.h>
/* #include <stdlib.h> */
#include "ed.h"

extern struct Window *Window;

static struct IntuiText Text2 = {
                             0, 1,      /* pen numbers */
                             0,         /* draw mode */
                             10, 24,     /* starting offsets */
                             NULL,      /* text attribute pointer */
                             NULL,
                             NULL
};
static struct IntuiText BodyText = {
                             0, 1,      /* pen numbers */
                             0,         /* draw mode */
                             10, 10,      /* starting offsets */
                             NULL,      /* text attribute pointer */
                             NULL,
                             &Text2
};
static struct IntuiText AbortText ={
                             0, 1,      /* pen numbers */
                             0,         /* draw mode */
                             4, 4,      /* starting offsets */
                             NULL,      /* text attribute pointer */
#ifdef DEUTSCH
                             "Abbrechen",
#else
                             "ABORT",
#endif
                             NULL
};

static struct IntuiText ContinueText ={
                             0, 1,      /* pen numbers */
                             0,         /* draw mode */
                             4, 4,      /* starting offsets */
                             NULL,      /* text attribute pointer */
#ifdef DEUTSCH
                             "Weiter",
#else
                             "CONTINUE",
#endif
                             NULL
};

extern char *title2;

int Error(message, mode)
char *message;
int   mode;
{
   struct IntuiText *cont;

   BodyText.IText = title2;
   Text2.IText = message;
   cont = ((mode) ? &ContinueText : NULL);

   if ( AutoRequest(Window,&BodyText,cont,&AbortText,0,0,320,70) )
     return TRUE;
   else
     return FALSE;
}
